/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.ExponentialBackoff$$Lambda$1;
import com.google.firebase.firestore.util.Logger;
import java.util.Date;

public class ExponentialBackoff {
    private final AsyncQueue queue;
    private final AsyncQueue.TimerId timerId;
    private final long initialDelayMs;
    private final double backoffFactor;
    private final long maxDelayMs;
    private long currentBaseMs;
    private long lastAttemptTime;
    private AsyncQueue.DelayedTask timerTask;

    public ExponentialBackoff(AsyncQueue queue, AsyncQueue.TimerId timerId, long initialDelayMs, double backoffFactor, long maxDelayMs) {
        this.queue = queue;
        this.timerId = timerId;
        this.initialDelayMs = initialDelayMs;
        this.backoffFactor = backoffFactor;
        this.maxDelayMs = maxDelayMs;
        this.lastAttemptTime = new Date().getTime();
        this.reset();
    }

    public void reset() {
        this.currentBaseMs = 0L;
    }

    public void resetToMax() {
        this.currentBaseMs = this.maxDelayMs;
    }

    public void backoffAndRun(Runnable task) {
        this.cancel();
        long desiredDelayWithJitterMs = this.currentBaseMs + this.jitterDelayMs();
        long delaySoFarMs = Math.max(0L, new Date().getTime() - this.lastAttemptTime);
        long remainingDelayMs = Math.max(0L, desiredDelayWithJitterMs - delaySoFarMs);
        if (this.currentBaseMs > 0L) {
            Logger.debug(this.getClass().getSimpleName(), "Backing off for %d ms (base delay: %d ms, delay with jitter: %d ms, last attempt: %d ms ago)", remainingDelayMs, this.currentBaseMs, desiredDelayWithJitterMs, delaySoFarMs);
        }
        this.timerTask = this.queue.enqueueAfterDelay(this.timerId, remainingDelayMs, ExponentialBackoff$$Lambda$1.lambdaFactory$(this, task));
        this.currentBaseMs = (long)((double)this.currentBaseMs * this.backoffFactor);
        if (this.currentBaseMs < this.initialDelayMs) {
            this.currentBaseMs = this.initialDelayMs;
        } else if (this.currentBaseMs > this.maxDelayMs) {
            this.currentBaseMs = this.maxDelayMs;
        }
    }

    public void cancel() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    private long jitterDelayMs() {
        return (long)((Math.random() - 0.5) * (double)this.currentBaseMs);
    }

    static /* synthetic */ void lambda$backoffAndRun$0(ExponentialBackoff this_, Runnable task) {
        this_.lastAttemptTime = new Date().getTime();
        task.run();
    }
}

