/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.remote.FirestoreCallCredentials$$Lambda$1;
import com.google.firebase.firestore.remote.FirestoreCallCredentials$$Lambda$2;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import io.grpc.CallCredentials;
import io.grpc.CallCredentials2;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;

public final class FirestoreCallCredentials
extends CallCredentials2 {
    private static final String LOG_TAG = "FirestoreCallCredentials";
    private static final Metadata.Key<String> AUTHORIZATION_HEADER = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final CredentialsProvider credentialsProvider;

    public FirestoreCallCredentials(CredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    public void thisUsesUnstableApi() {
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials2.MetadataApplier metadataApplier) {
        this.credentialsProvider.getToken().addOnSuccessListener(executor, FirestoreCallCredentials$$Lambda$1.lambdaFactory$(metadataApplier)).addOnFailureListener(executor, FirestoreCallCredentials$$Lambda$2.lambdaFactory$(metadataApplier));
    }

    static /* synthetic */ void lambda$applyRequestMetadata$1(CallCredentials2.MetadataApplier metadataApplier, Exception exception) {
        if (exception instanceof FirebaseApiNotAvailableException) {
            Logger.debug(LOG_TAG, "Firebase Auth API not available, not using authentication.", new Object[0]);
            metadataApplier.apply(new Metadata());
        } else if (exception instanceof FirebaseNoSignedInUserException) {
            Logger.debug(LOG_TAG, "No user signed in, not using authentication.", new Object[0]);
            metadataApplier.apply(new Metadata());
        } else {
            Logger.warn(LOG_TAG, "Failed to get token: %s.", exception);
            metadataApplier.fail(Status.UNAUTHENTICATED.withCause((Throwable)exception));
        }
    }

    static /* synthetic */ void lambda$applyRequestMetadata$0(CallCredentials2.MetadataApplier metadataApplier, String token) {
        Logger.debug(LOG_TAG, "Successfully fetched token.", new Object[0]);
        Metadata metadata = new Metadata();
        if (token != null) {
            metadata.put(AUTHORIZATION_HEADER, (Object)("Bearer " + token));
        }
        metadataApplier.apply(metadata);
    }
}

