/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import android.support.annotation.NonNull;
import com.google.firebase.firestore.model.value.FieldValueOptions;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Util;
import javax.annotation.Nullable;

public abstract class FieldValue
implements Comparable<FieldValue> {
    static final int TYPE_ORDER_NULL = 0;
    static final int TYPE_ORDER_BOOLEAN = 1;
    static final int TYPE_ORDER_NUMBER = 2;
    static final int TYPE_ORDER_TIMESTAMP = 3;
    static final int TYPE_ORDER_STRING = 4;
    static final int TYPE_ORDER_BLOB = 5;
    static final int TYPE_ORDER_REFERENCE = 6;
    static final int TYPE_ORDER_GEOPOINT = 7;
    static final int TYPE_ORDER_ARRAY = 8;
    static final int TYPE_ORDER_OBJECT = 9;

    public abstract int typeOrder();

    @Nullable
    public abstract Object value();

    @Nullable
    public Object value(FieldValueOptions options) {
        return this.value();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public abstract int compareTo(@NonNull FieldValue var1);

    public String toString() {
        Object val = this.value();
        return val == null ? "null" : val.toString();
    }

    protected int defaultCompareTo(FieldValue other) {
        int cmp = Util.compareIntegers(this.typeOrder(), other.typeOrder());
        Assert.hardAssert(cmp != 0, "Default compareTo should not be used for values of same type.", new Object[0]);
        return cmp;
    }
}

