/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.ObjectValue;
import java.util.Comparator;
import javax.annotation.Nullable;

public final class Document
extends MaybeDocument {
    private static final Comparator<Document> KEY_COMPARATOR = new Comparator<Document>(){

        @Override
        public int compare(Document left, Document right) {
            return left.getKey().compareTo(right.getKey());
        }
    };
    private final ObjectValue data;
    private final DocumentState documentState;
    private final com.google.firestore.v1beta1.Document proto;

    public static Comparator<Document> keyComparator() {
        return KEY_COMPARATOR;
    }

    @Nullable
    public com.google.firestore.v1beta1.Document getProto() {
        return this.proto;
    }

    public Document(DocumentKey key, SnapshotVersion version, ObjectValue data, DocumentState documentState) {
        super(key, version);
        this.data = data;
        this.documentState = documentState;
        this.proto = null;
    }

    public Document(DocumentKey key, SnapshotVersion version, ObjectValue data, DocumentState documentState, com.google.firestore.v1beta1.Document proto) {
        super(key, version);
        this.data = data;
        this.documentState = documentState;
        this.proto = proto;
    }

    public ObjectValue getData() {
        return this.data;
    }

    @Nullable
    public FieldValue getField(FieldPath path) {
        return this.data.get(path);
    }

    @Nullable
    public Object getFieldValue(FieldPath path) {
        FieldValue value = this.getField(path);
        return value == null ? null : value.value();
    }

    public boolean hasLocalMutations() {
        return this.documentState.equals((Object)DocumentState.LOCAL_MUTATIONS);
    }

    public boolean hasCommittedMutations() {
        return this.documentState.equals((Object)DocumentState.COMMITTED_MUTATIONS);
    }

    @Override
    public boolean hasPendingWrites() {
        return this.hasLocalMutations() || this.hasCommittedMutations();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return this.getVersion().equals(document.getVersion()) && this.getKey().equals(document.getKey()) && this.documentState.equals((Object)document.documentState) && this.data.equals(document.data);
    }

    public int hashCode() {
        int result = this.getKey().hashCode();
        result = 31 * result + this.data.hashCode();
        result = 31 * result + this.getVersion().hashCode();
        result = 31 * result + this.documentState.hashCode();
        return result;
    }

    public String toString() {
        return "Document{key=" + this.getKey() + ", data=" + this.data + ", version=" + this.getVersion() + ", documentState=" + this.documentState.name() + '}';
    }

    public static enum DocumentState {
        LOCAL_MUTATIONS,
        COMMITTED_MUTATIONS,
        SYNCED;

    }
}

