/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.firestore.local.MemoryMutationQueue;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.MemoryQueryCache;
import com.google.firebase.firestore.local.MemoryRemoteDocumentCache;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.model.DocumentKey;
import java.util.HashSet;
import java.util.Set;

class MemoryEagerReferenceDelegate
implements ReferenceDelegate {
    private ReferenceSet inMemoryPins;
    private final MemoryPersistence persistence;
    private Set<DocumentKey> orphanedDocuments;

    MemoryEagerReferenceDelegate(MemoryPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public long getCurrentSequenceNumber() {
        return -1L;
    }

    @Override
    public void setInMemoryPins(ReferenceSet inMemoryPins) {
        this.inMemoryPins = inMemoryPins;
    }

    @Override
    public void addReference(DocumentKey key) {
        this.orphanedDocuments.remove(key);
    }

    @Override
    public void removeReference(DocumentKey key) {
        this.orphanedDocuments.add(key);
    }

    @Override
    public void removeMutationReference(DocumentKey key) {
        this.orphanedDocuments.add(key);
    }

    @Override
    public void removeTarget(QueryData queryData) {
        MemoryQueryCache queryCache = this.persistence.getQueryCache();
        for (DocumentKey key : queryCache.getMatchingKeysForTargetId(queryData.getTargetId())) {
            this.orphanedDocuments.add(key);
        }
        queryCache.removeQueryData(queryData);
    }

    @Override
    public void onTransactionStarted() {
        this.orphanedDocuments = new HashSet<DocumentKey>();
    }

    @Override
    public void onTransactionCommitted() {
        MemoryRemoteDocumentCache remoteDocuments = this.persistence.getRemoteDocumentCache();
        for (DocumentKey key : this.orphanedDocuments) {
            if (this.isReferenced(key)) continue;
            remoteDocuments.remove(key);
        }
        this.orphanedDocuments = null;
    }

    @Override
    public void updateLimboDocument(DocumentKey key) {
        if (this.isReferenced(key)) {
            this.orphanedDocuments.remove(key);
        } else {
            this.orphanedDocuments.add(key);
        }
    }

    private boolean mutationQueuesContainKey(DocumentKey key) {
        for (MemoryMutationQueue queue : this.persistence.getMutationQueues()) {
            if (!queue.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isReferenced(DocumentKey key) {
        if (this.persistence.getQueryCache().containsKey(key)) {
            return true;
        }
        if (this.mutationQueuesContainKey(key)) {
            return true;
        }
        return this.inMemoryPins != null && this.inMemoryPins.containsKey(key);
    }
}

