/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.SparseArray;
import com.google.firebase.firestore.local.LruDelegate;
import com.google.firebase.firestore.local.LruGarbageCollector$$Lambda$1;
import com.google.firebase.firestore.local.LruGarbageCollector$$Lambda$2;
import com.google.firebase.firestore.local.LruGarbageCollector$RollingSequenceNumberBuffer$$Lambda$1;
import com.google.firebase.firestore.local.QueryData;
import java.util.Comparator;
import java.util.PriorityQueue;

class LruGarbageCollector {
    private final LruDelegate delegate;

    LruGarbageCollector(LruDelegate delegate) {
        this.delegate = delegate;
    }

    int calculateQueryCount(int percentile) {
        long targetCount = this.delegate.getTargetCount();
        return (int)((float)percentile / 100.0f * (float)targetCount);
    }

    long nthSequenceNumber(int count) {
        if (count == 0) {
            return -1L;
        }
        RollingSequenceNumberBuffer buffer = new RollingSequenceNumberBuffer(count);
        this.delegate.forEachTarget(LruGarbageCollector$$Lambda$1.lambdaFactory$(buffer));
        RollingSequenceNumberBuffer rollingSequenceNumberBuffer = buffer;
        rollingSequenceNumberBuffer.getClass();
        this.delegate.forEachOrphanedDocumentSequenceNumber(LruGarbageCollector$$Lambda$2.lambdaFactory$(rollingSequenceNumberBuffer));
        return buffer.getMaxValue();
    }

    int removeTargets(long upperBound, SparseArray<?> activeTargetIds) {
        return this.delegate.removeTargets(upperBound, activeTargetIds);
    }

    int removeOrphanedDocuments(long upperBound) {
        return this.delegate.removeOrphanedDocuments(upperBound);
    }

    static /* synthetic */ void lambda$nthSequenceNumber$0(RollingSequenceNumberBuffer buffer, QueryData queryData) {
        buffer.addElement(queryData.getSequenceNumber());
    }

    private static class RollingSequenceNumberBuffer {
        private static final Comparator<Long> COMPARATOR = LruGarbageCollector$RollingSequenceNumberBuffer$$Lambda$1.lambdaFactory$();
        private final PriorityQueue<Long> queue;
        private final int maxElements;

        RollingSequenceNumberBuffer(int count) {
            this.maxElements = count;
            this.queue = new PriorityQueue<Long>(count, COMPARATOR);
        }

        void addElement(Long sequenceNumber) {
            if (this.queue.size() < this.maxElements) {
                this.queue.add(sequenceNumber);
            } else {
                Long highestValue = this.queue.peek();
                if (sequenceNumber < highestValue) {
                    this.queue.poll();
                    this.queue.add(sequenceNumber);
                }
            }
        }

        long getMaxValue() {
            return this.queue.peek();
        }

        static /* synthetic */ int lambda$static$0(Long a, Long b) {
            return b.compareTo(a);
        }
    }
}

