/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.FirebaseFirestore;
import java.util.HashMap;
import java.util.Map;

class FirestoreMultiDbComponent {
    private final Map<String, FirebaseFirestore> instances = new HashMap<String, FirebaseFirestore>();
    private final FirebaseApp app;
    private final Context context;
    private final InternalAuthProvider authProvider;

    FirestoreMultiDbComponent(@NonNull Context context, @NonNull FirebaseApp app, @Nullable InternalAuthProvider authProvider) {
        this.context = context;
        this.app = app;
        this.authProvider = authProvider;
    }

    @NonNull
    synchronized FirebaseFirestore get(@NonNull String databaseName) {
        FirebaseFirestore firestore = this.instances.get(databaseName);
        if (firestore == null) {
            firestore = FirebaseFirestore.newInstance(this.context, this.app, this.authProvider, databaseName);
            this.instances.put(databaseName, firestore);
        }
        return firestore;
    }
}

