/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

@PublicApi
public final class FieldPath {
    private static final Pattern RESERVED = Pattern.compile("[~*/\\[\\]]");
    private final com.google.firebase.firestore.model.FieldPath internalPath;
    private static final FieldPath DOCUMENT_ID_INSTANCE = new FieldPath(com.google.firebase.firestore.model.FieldPath.KEY_PATH);

    private FieldPath(List<String> segments) {
        this.internalPath = com.google.firebase.firestore.model.FieldPath.fromSegments(segments);
    }

    private FieldPath(com.google.firebase.firestore.model.FieldPath internalPath) {
        this.internalPath = internalPath;
    }

    com.google.firebase.firestore.model.FieldPath getInternalPath() {
        return this.internalPath;
    }

    @PublicApi
    public static FieldPath of(String ... fieldNames) {
        Preconditions.checkArgument((fieldNames.length > 0 ? 1 : 0) != 0, (Object)"Invalid field path. Provided path must not be empty.");
        for (int i = 0; i < fieldNames.length; ++i) {
            Preconditions.checkArgument((fieldNames[i] != null && !fieldNames[i].isEmpty() ? 1 : 0) != 0, (Object)("Invalid field name at argument " + (i + 1) + ". Field names must not be null or empty."));
        }
        return new FieldPath(Arrays.asList(fieldNames));
    }

    @NonNull
    @PublicApi
    public static FieldPath documentId() {
        return DOCUMENT_ID_INSTANCE;
    }

    static FieldPath fromDotSeparatedPath(@NonNull String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Provided field path must not be null.");
        Preconditions.checkArgument((!RESERVED.matcher(path).find() ? 1 : 0) != 0, (Object)("Invalid field path (" + path + "). Paths must not contain '~', '*', '/', '[', or ']'"));
        try {
            return FieldPath.of(path.split("\\.", -1));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid field path (" + path + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
        }
    }

    public String toString() {
        return this.internalPath.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPath fieldPath = (FieldPath)o;
        return this.internalPath.equals(fieldPath.internalPath);
    }

    public int hashCode() {
        return this.internalPath.hashCode();
    }
}

