/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabaseComponent;
import com.google.firebase.database.Logger;
import com.google.firebase.database.annotations.Nullable;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.RepoManager;
import com.google.firebase.database.core.utilities.ParsedUrl;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.utilities.Validation;
import com.google.firebase.emulators.EmulatedServiceSettings;

public class FirebaseDatabase {
    private static final String SDK_VERSION = "21.0.0";
    private final FirebaseApp app;
    private final RepoInfo repoInfo;
    private final DatabaseConfig config;
    @Nullable
    private EmulatedServiceSettings emulatorSettings;
    private Repo repo;

    @NonNull
    public static FirebaseDatabase getInstance() {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance);
    }

    @NonNull
    public static FirebaseDatabase getInstance(@NonNull String url) {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance, url);
    }

    @NonNull
    public static FirebaseDatabase getInstance(@NonNull FirebaseApp app) {
        String databaseUrl = app.getOptions().getDatabaseUrl();
        if (databaseUrl == null) {
            if (app.getOptions().getProjectId() == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: Can't determine Firebase Database URL. Be sure to include a Project ID in your configuration.");
            }
            databaseUrl = "https://" + app.getOptions().getProjectId() + "-default-rtdb.firebaseio.com";
        }
        return FirebaseDatabase.getInstance(app, databaseUrl);
    }

    @NonNull
    public static synchronized FirebaseDatabase getInstance(@NonNull FirebaseApp app, @NonNull String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Preconditions.checkNotNull((Object)app, (Object)"Provided FirebaseApp must not be null.");
        FirebaseDatabaseComponent component = (FirebaseDatabaseComponent)app.get(FirebaseDatabaseComponent.class);
        Preconditions.checkNotNull((Object)component, (Object)"Firebase Database component is not present.");
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        if (!parsedUrl.path.isEmpty()) {
            throw new DatabaseException("Specified Database URL '" + url + "' is invalid. It should point to the root of a Firebase Database but it includes a path: " + parsedUrl.path.toString());
        }
        return component.get(parsedUrl.repoInfo);
    }

    static FirebaseDatabase createForTests(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        FirebaseDatabase db = new FirebaseDatabase(app, repoInfo, config);
        db.ensureRepo();
        return db;
    }

    FirebaseDatabase(@NonNull FirebaseApp app, @NonNull RepoInfo repoInfo, @NonNull DatabaseConfig config) {
        this.app = app;
        this.repoInfo = repoInfo;
        this.config = config;
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.app;
    }

    @NonNull
    public DatabaseReference getReference() {
        this.ensureRepo();
        return new DatabaseReference(this.repo, Path.getEmptyPath());
    }

    @NonNull
    public DatabaseReference getReference(@NonNull String path) {
        this.ensureRepo();
        if (path == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        Validation.validateRootPathString(path);
        Path childPath = new Path(path);
        return new DatabaseReference(this.repo, childPath);
    }

    @NonNull
    public DatabaseReference getReferenceFromUrl(@NonNull String url) {
        this.ensureRepo();
        if (url == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        parsedUrl.repoInfo.applyEmulatorSettings(this.emulatorSettings);
        if (!parsedUrl.repoInfo.host.equals(this.repo.getRepoInfo().host)) {
            throw new DatabaseException("Invalid URL (" + url + ") passed to getReference().  URL was expected to match configured Database URL: " + this.getReference());
        }
        return new DatabaseReference(this.repo, parsedUrl.path);
    }

    public void purgeOutstandingWrites() {
        this.ensureRepo();
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.repo.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.ensureRepo();
        RepoManager.resume(this.repo);
    }

    public void goOffline() {
        this.ensureRepo();
        RepoManager.interrupt(this.repo);
    }

    public synchronized void setLogLevel(@NonNull Logger.Level logLevel) {
        this.assertUnfrozen("setLogLevel");
        this.config.setLogLevel(logLevel);
    }

    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        this.assertUnfrozen("setPersistenceEnabled");
        this.config.setPersistenceEnabled(isEnabled);
    }

    public synchronized void setPersistenceCacheSizeBytes(long cacheSizeInBytes) {
        this.assertUnfrozen("setPersistenceCacheSizeBytes");
        this.config.setPersistenceCacheSizeBytes(cacheSizeInBytes);
    }

    public void useEmulator(@NonNull String host, int port) {
        if (this.repo != null) {
            throw new IllegalStateException("Cannot call useEmulator() after instance has already been initialized.");
        }
        this.emulatorSettings = new EmulatedServiceSettings(host, port);
    }

    @NonNull
    public static String getSdkVersion() {
        return SDK_VERSION;
    }

    private void assertUnfrozen(String methodCalled) {
        if (this.repo != null) {
            throw new DatabaseException("Calls to " + methodCalled + "() must be made before any other usage of FirebaseDatabase instance.");
        }
    }

    private synchronized void ensureRepo() {
        if (this.repo == null) {
            this.repoInfo.applyEmulatorSettings(this.emulatorSettings);
            this.repo = RepoManager.createRepo(this.config, this.repoInfo, this);
        }
    }

    DatabaseConfig getConfig() {
        return this.config;
    }
}

