/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.StringNode;

public class KeyIndex
extends Index {
    private static final KeyIndex INSTANCE = new KeyIndex();

    public static KeyIndex getInstance() {
        return INSTANCE;
    }

    private KeyIndex() {
    }

    @Override
    public boolean isDefinedOn(Node a) {
        return true;
    }

    @Override
    public NamedNode makePost(ChildKey name, Node value) {
        Utilities.hardAssert(value instanceof StringNode);
        return new NamedNode(ChildKey.fromString((String)value.getValue()), EmptyNode.Empty());
    }

    @Override
    public NamedNode maxPost() {
        return NamedNode.getMaxNode();
    }

    @Override
    public String getQueryDefinition() {
        return ".key";
    }

    @Override
    public int compare(NamedNode o1, NamedNode o2) {
        return o1.getName().compareTo(o2.getName());
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof KeyIndex;
    }

    public int hashCode() {
        return 37;
    }

    public String toString() {
        return "KeyIndex";
    }
}

