/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.utilities;

import android.net.Uri;
import android.util.Base64;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.utilities.Pair;
import com.google.firebase.database.core.utilities.ParsedUrl;
import com.google.firebase.database.core.utilities.Validation;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class Utilities {
    private static final char[] HEX_CHARACTERS = "0123456789abcdef".toCharArray();

    public static ParsedUrl parseUrl(String url) throws DatabaseException {
        try {
            Uri uri = Uri.parse((String)url);
            String scheme = uri.getScheme();
            if (scheme == null) {
                throw new IllegalArgumentException("Database URL does not specify a URL scheme");
            }
            String host = uri.getHost();
            if (host == null) {
                throw new IllegalArgumentException("Database URL does not specify a valid host");
            }
            RepoInfo repoInfo = new RepoInfo();
            repoInfo.host = host.toLowerCase();
            int port = uri.getPort();
            if (port != -1) {
                repoInfo.secure = scheme.equals("https") || scheme.equals("wss");
                repoInfo.host = repoInfo.host + ":" + port;
            } else {
                repoInfo.secure = true;
            }
            String namespaceParam = uri.getQueryParameter("ns");
            if (namespaceParam != null) {
                repoInfo.namespace = namespaceParam;
            } else {
                String[] parts = host.split("\\.", -1);
                repoInfo.namespace = parts[0].toLowerCase();
            }
            repoInfo.internalHost = repoInfo.host;
            String originalPathString = Utilities.extractPathString(url);
            originalPathString = originalPathString.replace("+", " ");
            Validation.validateRootPathString(originalPathString);
            ParsedUrl parsedUrl = new ParsedUrl();
            parsedUrl.path = new Path(originalPathString);
            parsedUrl.repoInfo = repoInfo;
            return parsedUrl;
        }
        catch (Exception e) {
            throw new DatabaseException("Invalid Firebase Database url specified: " + url, e);
        }
    }

    private static String extractPathString(String originalUrl) {
        int schemeOffset = originalUrl.indexOf("//");
        if (schemeOffset == -1) {
            throw new DatabaseException("Firebase Database URL is missing URL scheme");
        }
        String urlWithoutScheme = originalUrl.substring(schemeOffset + 2);
        int pathOffset = urlWithoutScheme.indexOf("/");
        if (pathOffset != -1) {
            int queryOffset = urlWithoutScheme.indexOf("?");
            if (queryOffset != -1) {
                return urlWithoutScheme.substring(pathOffset + 1, queryOffset);
            }
            return urlWithoutScheme.substring(pathOffset + 1);
        }
        return "";
    }

    public static String sha1HexDigest(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(input.getBytes("UTF-8"));
            byte[] bytes = md.digest();
            return Base64.encodeToString((byte[])bytes, (int)2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing SHA-1 MessageDigest provider.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is required for Firebase Database to run!");
        }
    }

    public static String stringHashV2Representation(String value) {
        String escaped = value;
        if (value.indexOf(92) != -1) {
            escaped = escaped.replace("\\", "\\\\");
        }
        if (value.indexOf(34) != -1) {
            escaped = escaped.replace("\"", "\\\"");
        }
        return '\"' + escaped + '\"';
    }

    public static String doubleToHashString(double value) {
        StringBuilder sb = new StringBuilder(16);
        long bits = Double.doubleToLongBits(value);
        for (int i = 7; i >= 0; --i) {
            int byteValue = (int)(bits >>> 8 * i & 0xFFL);
            int high = byteValue >> 4 & 0xF;
            int low = byteValue & 0xF;
            sb.append(HEX_CHARACTERS[high]);
            sb.append(HEX_CHARACTERS[low]);
        }
        return sb.toString();
    }

    public static Integer tryParseInt(String num) {
        if (num.length() > 11 || num.length() == 0) {
            return null;
        }
        int i = 0;
        boolean negative = false;
        if (num.charAt(0) == '-') {
            if (num.length() == 1) {
                return null;
            }
            negative = true;
            i = 1;
        }
        long number = 0L;
        while (i < num.length()) {
            char c = num.charAt(i);
            if (c < '0' || c > '9') {
                return null;
            }
            number = number * 10L + (long)(c - 48);
            ++i;
        }
        if (negative) {
            if (-number < Integer.MIN_VALUE) {
                return null;
            }
            return (int)(-number);
        }
        if (number > Integer.MAX_VALUE) {
            return null;
        }
        return (int)number;
    }

    public static int compareInts(int i, int j) {
        if (i < j) {
            return -1;
        }
        if (i == j) {
            return 0;
        }
        return 1;
    }

    public static int compareLongs(long i, long j) {
        if (i < j) {
            return -1;
        }
        if (i == j) {
            return 0;
        }
        return 1;
    }

    public static <C> C castOrNull(Object o, Class<C> clazz) {
        if (clazz.isAssignableFrom(o.getClass())) {
            return (C)o;
        }
        return null;
    }

    public static <C> C getOrNull(Object o, String key, Class<C> clazz) {
        if (o == null) {
            return null;
        }
        Map map = Utilities.castOrNull(o, Map.class);
        Object result = map.get(key);
        if (result != null) {
            return Utilities.castOrNull(result, clazz);
        }
        return null;
    }

    public static void hardAssert(boolean condition) {
        Utilities.hardAssert(condition, "");
    }

    public static void hardAssert(boolean condition, String message) {
        if (!condition) {
            throw new AssertionError((Object)("hardAssert failed: " + message));
        }
    }

    public static Pair<Task<Void>, DatabaseReference.CompletionListener> wrapOnComplete(DatabaseReference.CompletionListener optListener) {
        if (optListener == null) {
            final TaskCompletionSource source = new TaskCompletionSource();
            DatabaseReference.CompletionListener listener = new DatabaseReference.CompletionListener(){

                @Override
                public void onComplete(DatabaseError error, DatabaseReference ref) {
                    if (error != null) {
                        source.setException((Exception)error.toException());
                    } else {
                        source.setResult(null);
                    }
                }
            };
            return new Pair<Task<Void>, DatabaseReference.CompletionListener>(source.getTask(), listener);
        }
        return new Pair<Object, DatabaseReference.CompletionListener>(null, optListener);
    }
}

