/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.android.AndroidAuthTokenProvider;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.RepoInfo;
import java.util.HashMap;
import java.util.Map;

class FirebaseDatabaseComponent {
    private final Map<RepoInfo, FirebaseDatabase> instances = new HashMap<RepoInfo, FirebaseDatabase>();
    private final FirebaseApp app;
    private final AuthTokenProvider authProvider;

    FirebaseDatabaseComponent(@NonNull FirebaseApp app, @Nullable InternalAuthProvider authProvider) {
        this.app = app;
        this.authProvider = authProvider != null ? AndroidAuthTokenProvider.forAuthenticatedAccess(authProvider) : AndroidAuthTokenProvider.forUnauthenticatedAccess();
    }

    @NonNull
    synchronized FirebaseDatabase get(RepoInfo repo) {
        FirebaseDatabase database = this.instances.get(repo);
        if (database == null) {
            DatabaseConfig config = new DatabaseConfig();
            if (!this.app.isDefaultApp()) {
                config.setSessionPersistenceKey(this.app.getName());
            }
            config.setFirebaseApp(this.app);
            config.setAuthTokenProvider(this.authProvider);
            database = new FirebaseDatabase(this.app, repo, config);
            this.instances.put(repo, database);
        }
        return database;
    }
}

