/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzegg;
import com.google.android.gms.internal.zzegr;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.internal.zzejp;
import com.google.android.gms.internal.zzeju;
import com.google.android.gms.internal.zzelr;
import com.google.android.gms.internal.zzelu;
import com.google.android.gms.internal.zzemp;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzend;
import com.google.android.gms.internal.zzene;
import com.google.android.gms.internal.zzenh;
import com.google.android.gms.internal.zzenn;
import com.google.android.gms.internal.zzenr;
import com.google.android.gms.internal.zzens;
import com.google.android.gms.internal.zzent;
import com.google.android.gms.internal.zzenv;
import com.google.android.gms.internal.zzenx;
import com.google.android.gms.internal.zzepd;
import com.google.android.gms.internal.zzepf;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    @Hide
    protected final zzegx zzmwt;
    @Hide
    protected final zzegu zzmxa;
    @Hide
    private zzelr zzmxe;
    private final boolean zzmxf;

    private Query(zzegx zzegx2, zzegu zzegu2, zzelr zzelr2, boolean bl) throws DatabaseException {
        this.zzmwt = zzegx2;
        this.zzmxa = zzegu2;
        this.zzmxe = zzelr2;
        this.zzmxf = bl;
        zzelr zzelr3 = zzelr2;
        zzepd.zzb(!zzelr3.zzcas() || !zzelr3.zzcav() || !zzelr3.zzcay() || zzelr3.zzcaz(), "Validation of queries failed.");
    }

    Query(zzegx zzegx2, zzegu zzegu2) {
        this.zzmwt = zzegx2;
        this.zzmxa = zzegu2;
        this.zzmxe = zzelr.zznmi;
        this.zzmxf = false;
    }

    private static void zza(zzelr zzelr2) {
        if (zzelr2.zzcba().equals(zzenh.zzccu())) {
            zzenn zzenn2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzelr2.zzcas()) {
                zzenn2 = zzelr2.zzcat();
                if (zzelr2.zzcau() != zzemq.zzcbw() || !(zzenn2 instanceof zzenv)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzelr2.zzcav()) {
                zzenn2 = zzelr2.zzcaw();
                if (zzelr2.zzcax() != zzemq.zzcbx() || !(zzenn2 instanceof zzenv)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzelr2.zzcba().equals(zzens.zzccy()) && (zzelr2.zzcas() && !zzent.zzl(zzelr2.zzcat()) || zzelr2.zzcav() && !zzent.zzl(zzelr2.zzcaw()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzelr zzelr2) {
        if (zzelr2.zzcas() && zzelr2.zzcav() && zzelr2.zzcay() && !zzelr2.zzcaz()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbvf() {
        if (this.zzmxe.zzcas()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzmxe.zzcav()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbvg() {
        if (this.zzmxf) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzejp(this.zzmwt, valueEventListener, this.zzbvi()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzegg(this.zzmwt, childEventListener, this.zzbvi()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzejp(this.zzmwt, new zzp(this, valueEventListener), this.zzbvi()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzejp(this.zzmwt, valueEventListener, this.zzbvi()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzegg(this.zzmwt, childEventListener, this.zzbvi()));
    }

    private final void zza(zzegr zzegr2) {
        zzeju.zzbzo().zzj(zzegr2);
        this.zzmwt.zzp(new zzq(this, zzegr2));
    }

    private final void zzb(zzegr zzegr2) {
        zzeju.zzbzo().zzi(zzegr2);
        this.zzmwt.zzp(new zzr(this, zzegr2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzmxa.isEmpty() && this.zzmxa.zzbyq().equals(zzemq.zzcbz())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzmwt.zzp(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzenn zzenn2 = string != null ? new zzenv(string, zzene.zzcco()) : zzene.zzcco();
        return this.zza(zzenn2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzend(d, zzene.zzcco()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzemp(bl, zzene.zzcco()), string);
    }

    private final Query zza(zzenn zzenn2, String string) {
        zzepf.zzqp(string);
        if (!zzenn2.zzccd() && !zzenn2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzmxe.zzcas()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzemq zzemq2 = string != null ? zzemq.zzqf(string) : null;
        zzelr zzelr2 = this.zzmxe.zza(zzenn2, zzemq2);
        Query.zzb(zzelr2);
        Query.zza(zzelr2);
        return new Query(this.zzmwt, this.zzmxa, zzelr2, this.zzmxf);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzenn zzenn2 = string != null ? new zzenv(string, zzene.zzcco()) : zzene.zzcco();
        return this.zzb(zzenn2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzend(d, zzene.zzcco()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzemp(bl, zzene.zzcco()), string);
    }

    private final Query zzb(zzenn zzenn2, String string) {
        zzemq zzemq2;
        zzepf.zzqp(string);
        if (!zzenn2.zzccd() && !zzenn2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzemq zzemq3 = zzemq2 = string != null ? zzemq.zzqf(string) : null;
        if (this.zzmxe.zzcav()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzelr zzelr2 = this.zzmxe.zzb(zzenn2, zzemq2);
        Query.zzb(zzelr2);
        Query.zza(zzelr2);
        return new Query(this.zzmwt, this.zzmxa, zzelr2, this.zzmxf);
    }

    public Query equalTo(String string) {
        this.zzbvf();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbvf();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbvf();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbvf();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbvf();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbvf();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmxe.zzcay()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmwt, this.zzmxa, this.zzmxe.zzhi(n), this.zzmxf);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmxe.zzcay()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmwt, this.zzmxa, this.zzmxe.zzhj(n), this.zzmxf);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzepf.zzqn(string);
        this.zzbvg();
        zzegu zzegu2 = new zzegu(string);
        if (zzegu2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzenr zzenr2 = new zzenr(zzegu2);
        return new Query(this.zzmwt, this.zzmxa, this.zzmxe.zza(zzenr2), true);
    }

    public Query orderByPriority() {
        this.zzbvg();
        zzelr zzelr2 = this.zzmxe.zza(zzens.zzccy());
        Query.zza(zzelr2);
        return new Query(this.zzmwt, this.zzmxa, zzelr2, true);
    }

    public Query orderByKey() {
        this.zzbvg();
        zzelr zzelr2 = this.zzmxe.zza(zzenh.zzccu());
        Query.zza(zzelr2);
        return new Query(this.zzmwt, this.zzmxa, zzelr2, true);
    }

    public Query orderByValue() {
        this.zzbvg();
        return new Query(this.zzmwt, this.zzmxa, this.zzmxe.zza(zzenx.zzccz()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzmwt, this.zzmxa);
    }

    @Hide
    public final zzegu zzbvh() {
        return this.zzmxa;
    }

    @Hide
    public final zzelu zzbvi() {
        return new zzelu(this.zzmxa, this.zzmxe);
    }
}

