/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.RemoteConfigDeferredProxy;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CLSUUID;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsAppQualitySessionsSubscriber;
import com.google.firebase.crashlytics.internal.common.CrashlyticsController;
import com.google.firebase.crashlytics.internal.common.CrashlyticsFileMarker;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.OnDemandCounter;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator;
import com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers;
import com.google.firebase.crashlytics.internal.metadata.LogFileManager;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.settings.Settings;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import com.google.firebase.crashlytics.internal.stacktrace.MiddleOutFallbackStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.RemoveRepeatsStrategy;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CrashlyticsCore {
    private static final String MISSING_BUILD_ID_MSG = "The Crashlytics build ID is missing. This occurs when the Crashlytics Gradle plugin is missing from your app's build configuration. Please review the Firebase Crashlytics onboarding instructions at https://firebase.google.com/docs/crashlytics/get-started?platform=android#add-plugin";
    static final int MAX_STACK_SIZE = 1024;
    static final int NUM_STACK_REPETITIONS_ALLOWED = 10;
    static final String CRASHLYTICS_REQUIRE_BUILD_ID = "com.crashlytics.RequireBuildId";
    static final boolean CRASHLYTICS_REQUIRE_BUILD_ID_DEFAULT = true;
    static final int DEFAULT_MAIN_HANDLER_TIMEOUT_SEC = 3;
    private static final String ON_DEMAND_RECORDED_KEY = "com.crashlytics.on-demand.recorded-exceptions";
    private static final String ON_DEMAND_DROPPED_KEY = "com.crashlytics.on-demand.dropped-exceptions";
    private static final String INITIALIZATION_MARKER_FILE_NAME = "initialization_marker";
    static final String CRASH_MARKER_FILE_NAME = "crash_marker";
    private final Context context;
    private final FirebaseApp app;
    private final DataCollectionArbiter dataCollectionArbiter;
    private final OnDemandCounter onDemandCounter;
    private final long startTime;
    private CrashlyticsFileMarker initializationMarker;
    private CrashlyticsFileMarker crashMarker;
    private boolean didCrashOnPreviousExecution;
    private CrashlyticsController controller;
    private final IdManager idManager;
    private final FileStore fileStore;
    @VisibleForTesting
    public final BreadcrumbSource breadcrumbSource;
    private final AnalyticsEventLogger analyticsEventLogger;
    private final CrashlyticsAppQualitySessionsSubscriber sessionsSubscriber;
    private final CrashlyticsNativeComponent nativeComponent;
    private final RemoteConfigDeferredProxy remoteConfigDeferredProxy;
    private final CrashlyticsWorkers crashlyticsWorkers;

    public CrashlyticsCore(FirebaseApp app, IdManager idManager, CrashlyticsNativeComponent nativeComponent, DataCollectionArbiter dataCollectionArbiter, BreadcrumbSource breadcrumbSource, AnalyticsEventLogger analyticsEventLogger, FileStore fileStore, CrashlyticsAppQualitySessionsSubscriber sessionsSubscriber, RemoteConfigDeferredProxy remoteConfigDeferredProxy, CrashlyticsWorkers crashlyticsWorkers) {
        this.app = app;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.context = app.getApplicationContext();
        this.idManager = idManager;
        this.nativeComponent = nativeComponent;
        this.breadcrumbSource = breadcrumbSource;
        this.analyticsEventLogger = analyticsEventLogger;
        this.fileStore = fileStore;
        this.sessionsSubscriber = sessionsSubscriber;
        this.remoteConfigDeferredProxy = remoteConfigDeferredProxy;
        this.crashlyticsWorkers = crashlyticsWorkers;
        this.startTime = System.currentTimeMillis();
        this.onDemandCounter = new OnDemandCounter();
    }

    public boolean onPreExecute(AppData appData, SettingsProvider settingsProvider) {
        boolean requiresBuildId = CommonUtils.getBooleanResourceValue(this.context, CRASHLYTICS_REQUIRE_BUILD_ID, true);
        if (!CrashlyticsCore.isBuildIdValid(appData.buildId, requiresBuildId)) {
            throw new IllegalStateException(MISSING_BUILD_ID_MSG);
        }
        String sessionIdentifier = new CLSUUID().getSessionId();
        try {
            this.crashMarker = new CrashlyticsFileMarker(CRASH_MARKER_FILE_NAME, this.fileStore);
            this.initializationMarker = new CrashlyticsFileMarker(INITIALIZATION_MARKER_FILE_NAME, this.fileStore);
            UserMetadata userMetadata = new UserMetadata(sessionIdentifier, this.fileStore, this.crashlyticsWorkers);
            LogFileManager logFileManager = new LogFileManager(this.fileStore);
            MiddleOutFallbackStrategy stackTraceTrimmingStrategy = new MiddleOutFallbackStrategy(1024, new RemoveRepeatsStrategy(10));
            this.remoteConfigDeferredProxy.setupListener(userMetadata);
            SessionReportingCoordinator sessionReportingCoordinator = SessionReportingCoordinator.create(this.context, this.idManager, this.fileStore, appData, logFileManager, userMetadata, stackTraceTrimmingStrategy, settingsProvider, this.onDemandCounter, this.sessionsSubscriber, this.crashlyticsWorkers);
            this.controller = new CrashlyticsController(this.context, this.idManager, this.dataCollectionArbiter, this.fileStore, this.crashMarker, appData, userMetadata, logFileManager, sessionReportingCoordinator, this.nativeComponent, this.analyticsEventLogger, this.sessionsSubscriber, this.crashlyticsWorkers);
            boolean initializeSynchronously = this.didPreviousInitializationFail();
            this.checkForPreviousCrash();
            this.controller.enableExceptionHandling(sessionIdentifier, Thread.getDefaultUncaughtExceptionHandler(), settingsProvider);
            if (initializeSynchronously && CommonUtils.canTryConnection(this.context)) {
                Logger.getLogger().d("Crashlytics did not finish previous background initialization. Initializing synchronously.");
                this.finishInitSynchronously(settingsProvider);
                return false;
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("Crashlytics was not started due to an exception during initialization", e);
            this.controller = null;
            return false;
        }
        Logger.getLogger().d("Successfully configured exception handler.");
        return true;
    }

    @CanIgnoreReturnValue
    public Task<Void> doBackgroundInitializationAsync(SettingsProvider settingsProvider) {
        return this.crashlyticsWorkers.common.submit(() -> this.doBackgroundInitialization(settingsProvider));
    }

    private void doBackgroundInitialization(SettingsProvider settingsProvider) {
        CrashlyticsWorkers.checkBackgroundThread();
        this.markInitializationStarted();
        try {
            this.breadcrumbSource.registerBreadcrumbHandler(this::log);
            this.controller.saveVersionControlInfo();
            Settings settingsData = settingsProvider.getSettingsSync();
            if (!settingsData.featureFlagData.collectReports) {
                Logger.getLogger().d("Collection of crash reports disabled in Crashlytics settings.");
                throw new RuntimeException("Collection of crash reports disabled in Crashlytics settings.");
            }
            if (!this.controller.finalizeSessions(settingsProvider)) {
                Logger.getLogger().w("Previous sessions could not be finalized.");
            }
            this.controller.submitAllReports(settingsProvider.getSettingsAsync());
        }
        catch (Exception e) {
            Logger.getLogger().e("Crashlytics encountered a problem during asynchronous initialization.", e);
        }
        finally {
            this.markInitializationComplete();
        }
    }

    public boolean isCrashlyticsCollectionEnabled() {
        return this.dataCollectionArbiter.isAutomaticDataCollectionEnabled();
    }

    public void setCrashlyticsCollectionEnabled(@Nullable Boolean enabled) {
        this.dataCollectionArbiter.setCrashlyticsDataCollectionEnabled(enabled);
    }

    @NonNull
    public Task<Boolean> checkForUnsentReports() {
        return this.controller.checkForUnsentReports();
    }

    public Task<Void> sendUnsentReports() {
        return this.controller.sendUnsentReports();
    }

    public Task<Void> deleteUnsentReports() {
        return this.controller.deleteUnsentReports();
    }

    public static String getVersion() {
        return "19.4.0";
    }

    public void logException(@NonNull Throwable throwable, @NonNull Map<String, String> eventKeys) {
        this.crashlyticsWorkers.common.submit(() -> this.controller.writeNonFatalException(Thread.currentThread(), throwable, eventKeys));
    }

    public void log(String msg) {
        long timestamp = System.currentTimeMillis() - this.startTime;
        this.crashlyticsWorkers.common.submit(() -> this.crashlyticsWorkers.diskWrite.submit(() -> this.controller.writeToLog(timestamp, msg)));
    }

    public void setUserId(String identifier) {
        this.crashlyticsWorkers.common.submit(() -> this.controller.setUserId(identifier));
    }

    public void setCustomKey(String key, String value) {
        this.crashlyticsWorkers.common.submit(() -> this.controller.setCustomKey(key, value));
    }

    public void setCustomKeys(Map<String, String> keysAndValues) {
        if (!keysAndValues.isEmpty()) {
            this.crashlyticsWorkers.common.submit(() -> this.controller.setCustomKeys(keysAndValues));
        }
    }

    public void setInternalKey(String key, String value) {
        this.crashlyticsWorkers.common.submit(() -> this.controller.setInternalKey(key, value));
    }

    public void logFatalException(Throwable throwable) {
        Logger.getLogger().d("Recorded on-demand fatal events: " + this.onDemandCounter.getRecordedOnDemandExceptions());
        Logger.getLogger().d("Dropped on-demand fatal events: " + this.onDemandCounter.getDroppedOnDemandExceptions());
        this.crashlyticsWorkers.common.submit(() -> {
            this.controller.setInternalKey(ON_DEMAND_RECORDED_KEY, Integer.toString(this.onDemandCounter.getRecordedOnDemandExceptions()));
            this.controller.setInternalKey(ON_DEMAND_DROPPED_KEY, Integer.toString(this.onDemandCounter.getDroppedOnDemandExceptions()));
            this.controller.logFatalException(Thread.currentThread(), throwable);
        });
    }

    CrashlyticsController getController() {
        return this.controller;
    }

    private void finishInitSynchronously(SettingsProvider settingsProvider) {
        Future<?> future = this.crashlyticsWorkers.common.getExecutor().submit(() -> this.doBackgroundInitialization(settingsProvider));
        Logger.getLogger().d("Crashlytics detected incomplete initialization on previous app launch. Will initialize synchronously.");
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Logger.getLogger().e("Crashlytics was interrupted during initialization.", ex);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            Logger.getLogger().e("Crashlytics encountered a problem during initialization.", ex);
        }
        catch (TimeoutException ex) {
            Logger.getLogger().e("Crashlytics timed out during initialization.", ex);
        }
    }

    void markInitializationStarted() {
        CrashlyticsWorkers.checkBackgroundThread();
        this.initializationMarker.create();
        Logger.getLogger().v("Initialization marker file was created.");
    }

    void markInitializationComplete() {
        CrashlyticsWorkers.checkBackgroundThread();
        try {
            boolean removed = this.initializationMarker.remove();
            if (!removed) {
                Logger.getLogger().w("Initialization marker file was not properly removed.");
            }
        }
        catch (Exception ex) {
            Logger.getLogger().e("Problem encountered deleting Crashlytics initialization marker.", ex);
        }
    }

    boolean didPreviousInitializationFail() {
        return this.initializationMarker.isPresent();
    }

    private void checkForPreviousCrash() {
        Boolean result;
        Future<Boolean> future = this.crashlyticsWorkers.common.getExecutor().submit(() -> this.controller.didCrashOnPreviousExecution());
        try {
            result = future.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception ignored) {
            this.didCrashOnPreviousExecution = false;
            return;
        }
        this.didCrashOnPreviousExecution = Boolean.TRUE.equals(result);
    }

    public boolean didCrashOnPreviousExecution() {
        return this.didCrashOnPreviousExecution;
    }

    static boolean isBuildIdValid(String buildId, boolean requiresBuildId) {
        if (!requiresBuildId) {
            Logger.getLogger().v("Configured not to require a build ID.");
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)buildId)) {
            return true;
        }
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  | ");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".   \\ |  | /");
        Log.e((String)"FirebaseCrashlytics", (String)".    \\    /");
        Log.e((String)"FirebaseCrashlytics", (String)".     \\  /");
        Log.e((String)"FirebaseCrashlytics", (String)".      \\/");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)MISSING_BUILD_ID_MSG);
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".      /\\");
        Log.e((String)"FirebaseCrashlytics", (String)".     /  \\");
        Log.e((String)"FirebaseCrashlytics", (String)".    /    \\");
        Log.e((String)"FirebaseCrashlytics", (String)".   / |  | \\");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        return false;
    }
}

