/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import java.util.concurrent.atomic.AtomicBoolean;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final CrashListener crashListener;
    private final SettingsDataProvider settingsDataProvider;
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final CrashlyticsNativeComponent nativeComponent;
    private final AtomicBoolean isHandlingException;

    public CrashlyticsUncaughtExceptionHandler(CrashListener crashListener, SettingsDataProvider settingsProvider, Thread.UncaughtExceptionHandler defaultHandler, CrashlyticsNativeComponent nativeComponent) {
        this.crashListener = crashListener;
        this.settingsDataProvider = settingsProvider;
        this.defaultHandler = defaultHandler;
        this.isHandlingException = new AtomicBoolean(false);
        this.nativeComponent = nativeComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.isHandlingException.set(true);
        try {
            if (this.shouldRecordUncaughtException(thread, ex)) {
                this.crashListener.onUncaughtException(this.settingsDataProvider, thread, ex);
            } else {
                Logger.getLogger().d("Uncaught exception will not be recorded by Crashlytics.");
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("An error occurred in the uncaught exception handler", e);
        }
        finally {
            Logger.getLogger().d("Completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread, ex);
            this.isHandlingException.set(false);
        }
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    private boolean shouldRecordUncaughtException(Thread thread, Throwable ex) {
        if (thread == null) {
            Logger.getLogger().e("Crashlytics will not record uncaught exception; null thread");
            return false;
        }
        if (ex == null) {
            Logger.getLogger().e("Crashlytics will not record uncaught exception; null throwable");
            return false;
        }
        if (this.nativeComponent.hasCrashDataForCurrentSession()) {
            Logger.getLogger().d("Crashlytics will not record uncaught exception; native crash exists for session.");
            return false;
        }
        return true;
    }

    static interface CrashListener {
        public void onUncaughtException(SettingsDataProvider var1, Thread var2, Throwable var3);
    }
}

