/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KeysMap {
    private final Map<String, String> keys = new HashMap<String, String>();
    private int maxEntries;
    private int maxEntryLength;

    public KeysMap(int maxEntries, int maxEntryLength) {
        this.maxEntries = maxEntries;
        this.maxEntryLength = maxEntryLength;
    }

    @NonNull
    public Map<String, String> getKeys() {
        return Collections.unmodifiableMap(this.keys);
    }

    public void setKey(final String key, final String value) {
        this.setSyncKeys((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(KeysMap.this.sanitizeKey(key), KeysMap.this.sanitizeAttribute(value));
            }
        });
    }

    public void setKeys(Map<String, String> keysAndValues) {
        this.setSyncKeys(keysAndValues);
    }

    private synchronized void setSyncKeys(Map<String, String> keysAndValues) {
        HashMap<String, String> currentKeys = new HashMap<String, String>();
        HashMap<String, String> newKeys = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : keysAndValues.entrySet()) {
            String value;
            String key = this.sanitizeKey(entry.getKey());
            String string = value = entry.getValue() == null ? "" : this.sanitizeAttribute(entry.getValue());
            if (this.keys.containsKey(key)) {
                currentKeys.put(key, value);
                continue;
            }
            newKeys.put(key, value);
        }
        this.keys.putAll(currentKeys);
        if (this.keys.size() + newKeys.size() > this.maxEntries) {
            int keySlotsLeft = this.maxEntries - this.keys.size();
            Logger.getLogger().v("Exceeded maximum number of custom attributes (" + this.maxEntries + ").");
            ArrayList newKeyList = new ArrayList(newKeys.keySet());
            newKeys.keySet().retainAll(newKeyList.subList(0, keySlotsLeft));
        }
        this.keys.putAll(newKeys);
    }

    private String sanitizeKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Custom attribute key must not be null.");
        }
        return this.sanitizeAttribute(key);
    }

    public String sanitizeAttribute(String input) {
        if (input != null && (input = input.trim()).length() > this.maxEntryLength) {
            input = input.substring(0, this.maxEntryLength);
        }
        return input;
    }
}

