/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CrashlyticsLifecycleEvents;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportDataCapture;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator$$Lambda$1;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator$$Lambda$2;
import com.google.firebase.crashlytics.internal.common.UserMetadata;
import com.google.firebase.crashlytics.internal.log.LogFileManager;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class SessionReportingCoordinator
implements CrashlyticsLifecycleEvents {
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int EVENT_THREAD_IMPORTANCE = 4;
    private static final int MAX_CHAINED_EXCEPTION_DEPTH = 8;
    private final CrashlyticsReportDataCapture dataCapture;
    private final CrashlyticsReportPersistence reportPersistence;
    private final DataTransportCrashlyticsReportSender reportsSender;
    private final LogFileManager logFileManager;
    private final UserMetadata reportMetadata;

    public static SessionReportingCoordinator create(Context context, IdManager idManager, FileStore fileStore, AppData appData, LogFileManager logFileManager, UserMetadata userMetadata, StackTraceTrimmingStrategy stackTraceTrimmingStrategy, SettingsDataProvider settingsProvider) {
        File rootFilesDirectory = new File(fileStore.getFilesDirPath());
        CrashlyticsReportDataCapture dataCapture = new CrashlyticsReportDataCapture(context, idManager, appData, stackTraceTrimmingStrategy);
        CrashlyticsReportPersistence reportPersistence = new CrashlyticsReportPersistence(rootFilesDirectory, settingsProvider);
        DataTransportCrashlyticsReportSender reportSender = DataTransportCrashlyticsReportSender.create(context);
        return new SessionReportingCoordinator(dataCapture, reportPersistence, reportSender, logFileManager, userMetadata);
    }

    SessionReportingCoordinator(CrashlyticsReportDataCapture dataCapture, CrashlyticsReportPersistence reportPersistence, DataTransportCrashlyticsReportSender reportsSender, LogFileManager logFileManager, UserMetadata reportMetadata) {
        this.dataCapture = dataCapture;
        this.reportPersistence = reportPersistence;
        this.reportsSender = reportsSender;
        this.logFileManager = logFileManager;
        this.reportMetadata = reportMetadata;
    }

    @Override
    public void onBeginSession(@NonNull String sessionId, long timestamp) {
        CrashlyticsReport capturedReport = this.dataCapture.captureReportData(sessionId, timestamp);
        this.reportPersistence.persistReport(capturedReport);
    }

    @Override
    public void onLog(long timestamp, String log) {
        this.logFileManager.writeToLog(timestamp, log);
    }

    @Override
    public void onCustomKey(String key, String value) {
        this.reportMetadata.setCustomKey(key, value);
    }

    @Override
    public void onUserId(String userId) {
        this.reportMetadata.setUserId(userId);
    }

    public void persistFatalEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, long timestamp) {
        Logger.getLogger().d("Persisting fatal event for session " + sessionId);
        this.persistEvent(event, thread, sessionId, EVENT_TYPE_CRASH, timestamp, true);
    }

    public void persistNonFatalEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, long timestamp) {
        Logger.getLogger().d("Persisting non-fatal event for session " + sessionId);
        this.persistEvent(event, thread, sessionId, EVENT_TYPE_LOGGED, timestamp, false);
    }

    public void finalizeSessionWithNativeEvent(@NonNull String sessionId, @NonNull List<NativeSessionFile> nativeSessionFiles) {
        ArrayList<CrashlyticsReport.FilesPayload.File> nativeFiles = new ArrayList<CrashlyticsReport.FilesPayload.File>();
        for (NativeSessionFile nativeSessionFile : nativeSessionFiles) {
            CrashlyticsReport.FilesPayload.File filePayload = nativeSessionFile.asFilePayload();
            if (filePayload == null) continue;
            nativeFiles.add(filePayload);
        }
        this.reportPersistence.finalizeSessionWithNativeEvent(sessionId, CrashlyticsReport.FilesPayload.builder().setFiles(ImmutableList.from(nativeFiles)).build());
    }

    public void persistUserId(@NonNull String sessionId) {
        String userId = this.reportMetadata.getUserId();
        if (userId == null) {
            Logger.getLogger().d("Could not persist user ID; no user ID available");
            return;
        }
        this.reportPersistence.persistUserIdForSession(userId, sessionId);
    }

    public void finalizeSessions(long timestamp, @Nullable String currentSessionId) {
        this.reportPersistence.finalizeReports(currentSessionId, timestamp);
    }

    @NonNull
    public List<String> listSortedOpenSessionIds() {
        return this.reportPersistence.listSortedOpenSessionIds();
    }

    public boolean hasReportsToSend() {
        return this.reportPersistence.hasFinalizedReports();
    }

    public void removeAllReports() {
        this.reportPersistence.deleteAllReports();
    }

    public Task<Void> sendReports(@NonNull Executor reportSendCompleteExecutor) {
        List<CrashlyticsReportWithSessionId> reportsToSend = this.reportPersistence.loadFinalizedReports();
        ArrayList<Task> sendTasks = new ArrayList<Task>();
        for (CrashlyticsReportWithSessionId reportToSend : reportsToSend) {
            sendTasks.add(this.reportsSender.sendReport(reportToSend).continueWith(reportSendCompleteExecutor, SessionReportingCoordinator$$Lambda$1.lambdaFactory$(this)));
        }
        return Tasks.whenAll(sendTasks);
    }

    private void persistEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, @NonNull String eventType, long timestamp, boolean includeAllThreads) {
        boolean isHighPriority = eventType.equals(EVENT_TYPE_CRASH);
        CrashlyticsReport.Session.Event capturedEvent = this.dataCapture.captureEventData(event, thread, eventType, timestamp, 4, 8, includeAllThreads);
        CrashlyticsReport.Session.Event.Builder eventBuilder = capturedEvent.toBuilder();
        String content = this.logFileManager.getLogString();
        if (content != null) {
            eventBuilder.setLog(CrashlyticsReport.Session.Event.Log.builder().setContent(content).build());
        } else {
            Logger.getLogger().d("No log data to include with this event.");
        }
        List<CrashlyticsReport.CustomAttribute> sortedCustomAttributes = SessionReportingCoordinator.getSortedCustomAttributes(this.reportMetadata.getCustomKeys());
        if (!sortedCustomAttributes.isEmpty()) {
            eventBuilder.setApp(capturedEvent.getApp().toBuilder().setCustomAttributes(ImmutableList.from(sortedCustomAttributes)).build());
        }
        this.reportPersistence.persistEvent(eventBuilder.build(), sessionId, isHighPriority);
    }

    private boolean onReportSendComplete(@NonNull Task<CrashlyticsReportWithSessionId> task) {
        if (task.isSuccessful()) {
            CrashlyticsReportWithSessionId report = (CrashlyticsReportWithSessionId)task.getResult();
            Logger.getLogger().d("Crashlytics report successfully enqueued to DataTransport: " + report.getSessionId());
            this.reportPersistence.deleteFinalizedReport(report.getSessionId());
            return true;
        }
        Logger.getLogger().d("Crashlytics report could not be enqueued to DataTransport", task.getException());
        return false;
    }

    @NonNull
    private static List<CrashlyticsReport.CustomAttribute> getSortedCustomAttributes(@NonNull Map<String, String> attributes) {
        ArrayList<CrashlyticsReport.CustomAttribute> attributesList = new ArrayList<CrashlyticsReport.CustomAttribute>();
        attributesList.ensureCapacity(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributesList.add(CrashlyticsReport.CustomAttribute.builder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        Collections.sort(attributesList, SessionReportingCoordinator$$Lambda$2.lambdaFactory$());
        return attributesList;
    }

    static /* synthetic */ int lambda$getSortedCustomAttributes$0(CrashlyticsReport.CustomAttribute attr1, CrashlyticsReport.CustomAttribute attr2) {
        return attr1.getKey().compareTo(attr2.getKey());
    }

    static /* synthetic */ boolean access$lambda$0(SessionReportingCoordinator sessionReportingCoordinator, Task task) {
        return sessionReportingCoordinator.onReportSendComplete((Task<CrashlyticsReportWithSessionId>)task);
    }
}

