/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.report.network;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AbstractSpiCall;
import com.google.firebase.crashlytics.internal.common.ResponseParser;
import com.google.firebase.crashlytics.internal.network.HttpMethod;
import com.google.firebase.crashlytics.internal.network.HttpRequest;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.network.HttpResponse;
import com.google.firebase.crashlytics.internal.report.model.CreateReportRequest;
import com.google.firebase.crashlytics.internal.report.model.Report;
import com.google.firebase.crashlytics.internal.report.network.CreateReportSpiCall;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DefaultCreateReportSpiCall
extends AbstractSpiCall
implements CreateReportSpiCall {
    static final String MULTI_FILE_PARAM = "report[file";
    static final String FILE_PARAM = "report[file]";
    static final String IDENTIFIER_PARAM = "report[identifier]";
    static final String FILE_CONTENT_TYPE = "application/octet-stream";
    private final String version;

    public DefaultCreateReportSpiCall(String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, String version) {
        this(protocolAndHostOverride, url, requestFactory, HttpMethod.POST, version);
    }

    DefaultCreateReportSpiCall(String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, HttpMethod method, String version) {
        super(protocolAndHostOverride, url, requestFactory, method);
        this.version = version;
    }

    @Override
    public boolean invoke(CreateReportRequest requestData, boolean dataCollectionToken) {
        if (!dataCollectionToken) {
            throw new RuntimeException("An invalid data collection token was used.");
        }
        HttpRequest httpRequest = this.getHttpRequest();
        httpRequest = this.applyHeadersTo(httpRequest, requestData);
        httpRequest = this.applyMultipartDataTo(httpRequest, requestData.report);
        Logger.getLogger().d("Sending report to: " + this.getUrl());
        try {
            HttpResponse httpResponse = httpRequest.execute();
            int statusCode = httpResponse.code();
            Logger.getLogger().d("Create report request ID: " + httpResponse.header("X-REQUEST-ID"));
            Logger.getLogger().d("Result was: " + statusCode);
            return 0 == ResponseParser.parse(statusCode);
        }
        catch (IOException ioe) {
            Logger.getLogger().e("Create report HTTP request failed.", ioe);
            throw new RuntimeException(ioe);
        }
    }

    private HttpRequest applyHeadersTo(HttpRequest request, CreateReportRequest requestData) {
        request = request.header("X-CRASHLYTICS-GOOGLE-APP-ID", requestData.googleAppId).header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", this.version);
        Map<String, String> customHeaders = requestData.report.getCustomHeaders();
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            request = request.header(entry);
        }
        return request;
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, Report report) {
        request = request.part(IDENTIFIER_PARAM, report.getIdentifier());
        if (report.getFiles().length == 1) {
            Logger.getLogger().d("Adding single file " + report.getFileName() + " to report " + report.getIdentifier());
            return request.part(FILE_PARAM, report.getFileName(), FILE_CONTENT_TYPE, report.getFile());
        }
        int i = 0;
        for (File file : report.getFiles()) {
            Logger.getLogger().d("Adding file " + file.getName() + " to report " + report.getIdentifier());
            request = request.part(MULTI_FILE_PARAM + i + "]", file.getName(), FILE_CONTENT_TYPE, file);
            ++i;
        }
        return request;
    }
}

