/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import android.content.Context;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.persistence.FileStoreImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import org.json.JSONObject;

public class CachedSettingsIo {
    private static final String SETTINGS_CACHE_FILENAME = "com.crashlytics.settings.json";
    private final Context context;

    public CachedSettingsIo(Context context) {
        this.context = context;
    }

    private File getSettingsFile() {
        return new File(new FileStoreImpl(this.context).getFilesDir(), SETTINGS_CACHE_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject readCachedSettings() {
        Logger.getLogger().d("Reading cached settings...");
        FileInputStream fis = null;
        JSONObject toReturn = null;
        try {
            File settingsFile = this.getSettingsFile();
            if (settingsFile.exists()) {
                fis = new FileInputStream(settingsFile);
                String settingsStr = CommonUtils.streamToString(fis);
                toReturn = new JSONObject(settingsStr);
            } else {
                Logger.getLogger().d("No cached settings found.");
            }
            CommonUtils.closeOrLog(fis, "Error while closing settings cache file.");
        }
        catch (Exception e) {
            Logger.getLogger().e("Failed to fetch cached settings", e);
        }
        finally {
            CommonUtils.closeOrLog(fis, "Error while closing settings cache file.");
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCachedSettings(long expiresAtMillis, JSONObject settingsJson) {
        Logger.getLogger().d("Writing settings to cache file...");
        if (settingsJson != null) {
            FileWriter writer = null;
            try {
                settingsJson.put("expires_at", expiresAtMillis);
                writer = new FileWriter(this.getSettingsFile());
                writer.write(settingsJson.toString());
                writer.flush();
                CommonUtils.closeOrLog(writer, "Failed to close settings writer.");
            }
            catch (Exception e) {
                Logger.getLogger().e("Failed to cache settings", e);
            }
            finally {
                CommonUtils.closeOrLog(writer, "Failed to close settings writer.");
            }
        }
    }
}

