/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class FileBackedNativeSessionFile
implements NativeSessionFile {
    @NonNull
    private final File file;
    @NonNull
    private final String dataTransportFilename;
    @NonNull
    private final String reportsEndpointFilename;

    FileBackedNativeSessionFile(@NonNull String dataTransportFilename, @NonNull String reportsEndpointFilename, @NonNull File file) {
        this.dataTransportFilename = dataTransportFilename;
        this.reportsEndpointFilename = reportsEndpointFilename;
        this.file = file;
    }

    @Override
    @NonNull
    public String getReportsEndpointFilename() {
        return this.reportsEndpointFilename;
    }

    @Override
    @Nullable
    public InputStream getStream() {
        if (!this.file.exists() || !this.file.isFile()) {
            return null;
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException f) {
            return null;
        }
    }

    @Override
    @Nullable
    public CrashlyticsReport.FilesPayload.File asFilePayload() {
        byte[] bytes = this.asBytes();
        return bytes != null ? CrashlyticsReport.FilesPayload.File.builder().setContents(bytes).setFilename(this.dataTransportFilename).build() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] asBytes() {
        byte[] readBuffer = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream stream = this.getStream();
            Throwable throwable = null;
            try {
                int read;
                if (stream == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                while ((read = stream.read(readBuffer)) > 0) {
                    bos.write(readBuffer, 0, read);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

