/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Debug;
import android.os.StatFs;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.google.firebase.crashlytics.internal.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.crypto.Cipher;

public class CommonUtils {
    private static final String LOG_PRIORITY_NAME_ASSERT = "A";
    private static final String LOG_PRIORITY_NAME_DEBUG = "D";
    private static final String LOG_PRIORITY_NAME_ERROR = "E";
    private static final String LOG_PRIORITY_NAME_INFO = "I";
    private static final String LOG_PRIORITY_NAME_VERBOSE = "V";
    private static final String LOG_PRIORITY_NAME_WARN = "W";
    private static final String LOG_PRIORITY_NAME_UNKNOWN = "?";
    private static final String SHA1_INSTANCE = "SHA-1";
    private static final String SHA256_INSTANCE = "SHA-256";
    private static final String GOOGLE_SDK = "google_sdk";
    private static final String SDK = "sdk";
    public static final String SHARED_PREFS_NAME = "com.google.firebase.crashlytics";
    public static final String LEGACY_SHARED_PREFS_NAME = "com.crashlytics.prefs";
    private static final String CLS_TRACE_PREFERENCE_NAME = "com.crashlytics.Trace";
    private static final boolean CLS_TRACE_DEFAULT = false;
    private static Boolean clsTrace = null;
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final String MAPPING_FILE_ID_RESOURCE_NAME = "com.google.firebase.crashlytics.mapping_file_id";
    static final String LEGACY_MAPPING_FILE_ID_RESOURCE_NAME = "com.crashlytics.android.build_id";
    private static final String UNITY_EDITOR_VERSION = "com.google.firebase.crashlytics.unity_version";
    private static final long UNCALCULATED_TOTAL_RAM = -1L;
    static final int BYTES_IN_A_GIGABYTE = 0x40000000;
    static final int BYTES_IN_A_MEGABYTE = 0x100000;
    static final int BYTES_IN_A_KILOBYTE = 1024;
    private static long totalRamInBytes = -1L;
    public static final int DEVICE_STATE_ISSIMULATOR = 1;
    public static final int DEVICE_STATE_JAILBROKEN = 2;
    public static final int DEVICE_STATE_DEBUGGERATTACHED = 4;
    public static final int DEVICE_STATE_BETAOS = 8;
    public static final int DEVICE_STATE_VENDORINTERNAL = 16;
    public static final int DEVICE_STATE_COMPROMISEDLIBRARIES = 32;
    public static final Comparator<File> FILE_MODIFIED_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file0, File file1) {
            return (int)(file0.lastModified() - file1.lastModified());
        }
    };

    public static SharedPreferences getSharedPrefs(Context context) {
        return context.getSharedPreferences(SHARED_PREFS_NAME, 0);
    }

    public static SharedPreferences getLegacySharedPrefs(Context context) {
        return context.getSharedPreferences(LEGACY_SHARED_PREFS_NAME, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractFieldFromSystemFile(File file, String fieldname) {
        String toReturn = null;
        if (file.exists()) {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(file), 1024);
                while ((line = br.readLine()) != null) {
                    Pattern pattern = Pattern.compile("\\s*:\\s*");
                    String[] pieces = pattern.split(line, 2);
                    if (pieces.length <= 1 || !pieces[0].equals(fieldname)) continue;
                    toReturn = pieces[1];
                    break;
                }
            }
            catch (Exception e) {
                try {
                    Logger.getLogger().e("Error parsing " + file, e);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeOrLog(br, "Failed to close system file reader.");
                    throw throwable;
                }
                CommonUtils.closeOrLog(br, "Failed to close system file reader.");
            }
            CommonUtils.closeOrLog(br, "Failed to close system file reader.");
        }
        return toReturn;
    }

    public static int getCpuArchitectureInt() {
        return Architecture.getValue().ordinal();
    }

    public static synchronized long getTotalRamInBytes() {
        if (totalRamInBytes == -1L) {
            long bytes = 0L;
            String result = CommonUtils.extractFieldFromSystemFile(new File("/proc/meminfo"), "MemTotal");
            if (!TextUtils.isEmpty((CharSequence)result)) {
                result = result.toUpperCase(Locale.US);
                try {
                    if (result.endsWith("KB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "KB", 1024);
                    } else if (result.endsWith("MB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "MB", 0x100000);
                    } else if (result.endsWith("GB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "GB", 0x40000000);
                    } else {
                        Logger.getLogger().d("Unexpected meminfo format while computing RAM: " + result);
                    }
                }
                catch (NumberFormatException e) {
                    Logger.getLogger().e("Unexpected meminfo format while computing RAM: " + result, e);
                }
            }
            totalRamInBytes = bytes;
        }
        return totalRamInBytes;
    }

    static long convertMemInfoToBytes(String memInfo, String notation, int notationMultiplier) {
        return Long.parseLong(memInfo.split(notation)[0].trim()) * (long)notationMultiplier;
    }

    public static ActivityManager.RunningAppProcessInfo getAppProcessInfo(String packageName, Context context) {
        ActivityManager actman = (ActivityManager)context.getSystemService("activity");
        List processes = actman.getRunningAppProcesses();
        ActivityManager.RunningAppProcessInfo procInfo = null;
        if (processes != null) {
            for (ActivityManager.RunningAppProcessInfo info : processes) {
                if (!info.processName.equals(packageName)) continue;
                procInfo = info;
                break;
            }
        }
        return procInfo;
    }

    public static String streamToString(InputStream is) throws IOException {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static String sha1(String source) {
        return CommonUtils.hash(source, SHA1_INSTANCE);
    }

    public static String sha256(String source) {
        return CommonUtils.hash(source, SHA256_INSTANCE);
    }

    public static String sha1(InputStream source) {
        return CommonUtils.hash(source, SHA1_INSTANCE);
    }

    private static String hash(String s, String algorithm) {
        return CommonUtils.hash(s.getBytes(), algorithm);
    }

    private static String hash(InputStream source, String sha1Instance) {
        try {
            MessageDigest digest = MessageDigest.getInstance(sha1Instance);
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = source.read(buffer)) != -1) {
                digest.update(buffer, 0, length);
            }
            return CommonUtils.hexify(digest.digest());
        }
        catch (Exception e) {
            Logger.getLogger().e("Could not calculate hash for app icon.", e);
            return "";
        }
    }

    private static String hash(byte[] bytes, String algorithm) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.getLogger().e("Could not create hashing algorithm: " + algorithm + ", returning empty string.", e);
            return "";
        }
        digest.update(bytes);
        return CommonUtils.hexify(digest.digest());
    }

    public static String createInstanceIdFrom(String ... sliceIds) {
        if (sliceIds == null || sliceIds.length == 0) {
            return null;
        }
        ArrayList<String> sliceIdList = new ArrayList<String>();
        for (String id : sliceIds) {
            if (id == null) continue;
            sliceIdList.add(id.replace("-", "").toLowerCase(Locale.US));
        }
        Collections.sort(sliceIdList);
        StringBuilder sb = new StringBuilder();
        for (String id : sliceIdList) {
            sb.append(id);
        }
        String concatValue = sb.toString();
        return concatValue.length() > 0 ? CommonUtils.sha1(concatValue) : null;
    }

    public static long calculateFreeRamInBytes(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(mi);
        return mi.availMem;
    }

    public static long calculateUsedDiskSpaceInBytes(String path) {
        StatFs statFs = new StatFs(path);
        long blockSizeBytes = statFs.getBlockSize();
        long totalSpaceBytes = blockSizeBytes * (long)statFs.getBlockCount();
        long availableSpaceBytes = blockSizeBytes * (long)statFs.getAvailableBlocks();
        return totalSpaceBytes - availableSpaceBytes;
    }

    public static boolean getProximitySensorEnabled(Context context) {
        if (CommonUtils.isEmulator(context)) {
            return false;
        }
        SensorManager sm = (SensorManager)context.getSystemService("sensor");
        Sensor prox = sm.getDefaultSensor(8);
        return prox != null;
    }

    public static void logControlled(Context context, String msg) {
        if (CommonUtils.isClsTrace(context)) {
            Logger.getLogger().d(msg);
        }
    }

    public static void logControlledError(Context context, String msg, Throwable tr) {
        if (CommonUtils.isClsTrace(context)) {
            Logger.getLogger().e(msg);
        }
    }

    public static void logControlled(Context context, int level, String tag, String msg) {
        if (CommonUtils.isClsTrace(context)) {
            Logger.getLogger().log(level, msg);
        }
    }

    @Deprecated
    public static boolean isLoggingEnabled(Context context) {
        return false;
    }

    public static boolean isClsTrace(Context context) {
        if (clsTrace == null) {
            clsTrace = CommonUtils.getBooleanResourceValue(context, CLS_TRACE_PREFERENCE_NAME, false);
        }
        return clsTrace;
    }

    public static boolean getBooleanResourceValue(Context context, String key, boolean defaultValue) {
        Resources resources;
        if (context != null && (resources = context.getResources()) != null) {
            int id = CommonUtils.getResourcesIdentifier(context, key, "bool");
            if (id > 0) {
                return resources.getBoolean(id);
            }
            id = CommonUtils.getResourcesIdentifier(context, key, "string");
            if (id > 0) {
                return Boolean.parseBoolean(context.getString(id));
            }
        }
        return defaultValue;
    }

    public static int getResourcesIdentifier(Context context, String key, String resourceType) {
        Resources resources = context.getResources();
        return resources.getIdentifier(key, resourceType, CommonUtils.getResourcePackageName(context));
    }

    public static boolean isEmulator(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return SDK.equals(Build.PRODUCT) || GOOGLE_SDK.equals(Build.PRODUCT) || androidId == null;
    }

    public static boolean isRooted(Context context) {
        boolean isEmulator = CommonUtils.isEmulator(context);
        String buildTags = Build.TAGS;
        if (!isEmulator && buildTags != null && buildTags.contains("test-keys")) {
            return true;
        }
        File file = new File("/system/app/Superuser.apk");
        if (file.exists()) {
            return true;
        }
        file = new File("/system/xbin/su");
        return !isEmulator && file.exists();
    }

    public static boolean isDebuggerAttached() {
        return Debug.isDebuggerConnected() || Debug.waitingForDebugger();
    }

    public static int getDeviceState(Context context) {
        int deviceState = 0;
        if (CommonUtils.isEmulator(context)) {
            deviceState |= 1;
        }
        if (CommonUtils.isRooted(context)) {
            deviceState |= 2;
        }
        if (CommonUtils.isDebuggerAttached()) {
            deviceState |= 4;
        }
        return deviceState;
    }

    @Deprecated
    public static Cipher createCipher(int mode, String key) throws InvalidKeyException {
        throw new InvalidKeyException("This method is deprecated");
    }

    public static String hexify(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_VALUES[v >>> 4];
            hexChars[i * 2 + 1] = HEX_VALUES[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] dehexify(String string) {
        int len = string.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return data;
    }

    public static boolean isAppDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    public static String getStringsFileValue(Context context, String key) {
        int id = CommonUtils.getResourcesIdentifier(context, key, "string");
        if (id > 0) {
            return context.getString(id);
        }
        return "";
    }

    public static void closeOrLog(Closeable c, String message) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                Logger.getLogger().e(message, e);
            }
        }
    }

    public static void flushOrLog(Flushable f, String message) {
        if (f != null) {
            try {
                f.flush();
            }
            catch (IOException e) {
                Logger.getLogger().e(message, e);
            }
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String padWithZerosToMaxIntWidth(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be zero or greater");
        }
        return String.format(Locale.US, "%1$10s", value).replace(' ', '0');
    }

    public static boolean stringsEqualIncludingNull(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    public static String getResourcePackageName(Context context) {
        String resourcePackageName;
        int iconId = context.getApplicationContext().getApplicationInfo().icon;
        if (iconId > 0) {
            try {
                resourcePackageName = context.getResources().getResourcePackageName(iconId);
            }
            catch (Resources.NotFoundException e) {
                resourcePackageName = context.getPackageName();
            }
        } else {
            resourcePackageName = context.getPackageName();
        }
        return resourcePackageName;
    }

    public static void copyStream(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int count;
        while ((count = is.read(buffer)) != -1) {
            os.write(buffer, 0, count);
        }
    }

    public static String logPriorityToString(int priority) {
        switch (priority) {
            case 7: {
                return LOG_PRIORITY_NAME_ASSERT;
            }
            case 3: {
                return LOG_PRIORITY_NAME_DEBUG;
            }
            case 6: {
                return LOG_PRIORITY_NAME_ERROR;
            }
            case 4: {
                return LOG_PRIORITY_NAME_INFO;
            }
            case 2: {
                return LOG_PRIORITY_NAME_VERBOSE;
            }
            case 5: {
                return LOG_PRIORITY_NAME_WARN;
            }
        }
        return LOG_PRIORITY_NAME_UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAppIconHashOrNull(Context context) {
        String string;
        InputStream is = null;
        try {
            is = context.getResources().openRawResource(CommonUtils.getAppIconResourceId(context));
            String sha1 = CommonUtils.sha1(is);
            string = CommonUtils.isNullOrEmpty(sha1) ? null : sha1;
        }
        catch (Exception e) {
            try {
                Logger.getLogger().w("Could not calculate hash for app icon:" + e.getMessage());
            }
            catch (Throwable throwable) {
                CommonUtils.closeOrLog(is, "Failed to close icon input stream.");
                throw throwable;
            }
            CommonUtils.closeOrLog(is, "Failed to close icon input stream.");
            return null;
        }
        CommonUtils.closeOrLog(is, "Failed to close icon input stream.");
        return string;
    }

    public static int getAppIconResourceId(Context context) {
        return context.getApplicationContext().getApplicationInfo().icon;
    }

    public static String getMappingFileId(Context context) {
        String mappingFileId = null;
        int id = CommonUtils.getResourcesIdentifier(context, MAPPING_FILE_ID_RESOURCE_NAME, "string");
        if (id == 0) {
            id = CommonUtils.getResourcesIdentifier(context, LEGACY_MAPPING_FILE_ID_RESOURCE_NAME, "string");
        }
        if (id != 0) {
            mappingFileId = context.getResources().getString(id);
        }
        return mappingFileId;
    }

    public static String resolveUnityEditorVersion(Context context) {
        String version = null;
        int id = CommonUtils.getResourcesIdentifier(context, UNITY_EDITOR_VERSION, "string");
        if (id != 0) {
            version = context.getResources().getString(id);
            Logger.getLogger().d("Unity Editor version is: " + version);
        }
        return version;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean checkPermission(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    public static void hideKeyboard(Context context, View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void openKeyboard(Context context, View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm != null) {
            imm.showSoftInputFromInputMethod(view.getWindowToken(), 0);
        }
    }

    @TargetApi(value=16)
    public static void finishAffinity(Context context, int resultCode) {
        if (context instanceof Activity) {
            CommonUtils.finishAffinity((Activity)context, resultCode);
        }
    }

    @TargetApi(value=16)
    public static void finishAffinity(Activity activity, int resultCode) {
        if (activity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            activity.finishAffinity();
        } else {
            activity.setResult(resultCode);
            activity.finish();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean canTryConnection(Context context) {
        if (CommonUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
        return true;
    }

    static enum Architecture {
        X86_32,
        X86_64,
        ARM_UNKNOWN,
        PPC,
        PPC64,
        ARMV6,
        ARMV7,
        UNKNOWN,
        ARMV7S,
        ARM64;

        private static final Map<String, Architecture> matcher;

        static Architecture getValue() {
            String arch = Build.CPU_ABI;
            if (TextUtils.isEmpty((CharSequence)arch)) {
                Logger.getLogger().d("Architecture#getValue()::Build.CPU_ABI returned null or empty");
                return UNKNOWN;
            }
            Architecture value = matcher.get(arch = arch.toLowerCase(Locale.US));
            if (value == null) {
                value = UNKNOWN;
            }
            return value;
        }

        static {
            matcher = new HashMap<String, Architecture>(4);
            matcher.put("armeabi-v7a", ARMV7);
            matcher.put("armeabi", ARMV6);
            matcher.put("arm64-v8a", ARM64);
            matcher.put("x86", X86_32);
        }
    }
}

