/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

class BytesBackedNativeSessionFile
implements NativeSessionFile {
    @Nullable
    private final byte[] bytes;
    @NonNull
    private final String dataTransportFilename;
    @NonNull
    private final String reportsEndpointFilename;

    BytesBackedNativeSessionFile(@NonNull String dataTransportFilename, @NonNull String reportsEndpointFilename, @Nullable byte[] bytes) {
        this.dataTransportFilename = dataTransportFilename;
        this.reportsEndpointFilename = reportsEndpointFilename;
        this.bytes = bytes;
    }

    @Override
    @NonNull
    public String getReportsEndpointFilename() {
        return this.reportsEndpointFilename;
    }

    @Override
    @Nullable
    public InputStream getStream() {
        return this.isEmpty() ? null : new ByteArrayInputStream(this.bytes);
    }

    @Override
    @Nullable
    public CrashlyticsReport.FilesPayload.File asFilePayload() {
        return this.isEmpty() ? null : CrashlyticsReport.FilesPayload.File.builder().setContents(this.bytes).setFilename(this.dataTransportFilename).build();
    }

    private boolean isEmpty() {
        return this.bytes == null || this.bytes.length == 0;
    }
}

