/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.report;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.BackgroundPriorityRunnable;
import com.google.firebase.crashlytics.internal.report.ReportManager;
import com.google.firebase.crashlytics.internal.report.model.CreateReportRequest;
import com.google.firebase.crashlytics.internal.report.model.Report;
import com.google.firebase.crashlytics.internal.report.network.CreateReportSpiCall;
import com.google.firebase.crashlytics.internal.settings.model.AppSettingsData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ReportUploader {
    private static final short[] RETRY_INTERVALS = new short[]{10, 20, 30, 60, 120, 300};
    private final CreateReportSpiCall createReportCall;
    private final String organizationId;
    private final String googleAppId;
    private final boolean isUsingReportsEndpoint;
    private final ReportManager reportManager;
    private final HandlingExceptionCheck handlingExceptionCheck;
    private Thread uploadThread;

    public ReportUploader(String organizationId, String googleAppId, boolean isUsingReportsEndpoint, ReportManager reportManager, CreateReportSpiCall createReportCall, HandlingExceptionCheck handlingExceptionCheck) {
        if (createReportCall == null) {
            throw new IllegalArgumentException("createReportCall must not be null.");
        }
        this.createReportCall = createReportCall;
        this.organizationId = organizationId;
        this.googleAppId = googleAppId;
        this.isUsingReportsEndpoint = isUsingReportsEndpoint;
        this.reportManager = reportManager;
        this.handlingExceptionCheck = handlingExceptionCheck;
    }

    public synchronized void uploadReportsAsync(List<Report> reports, boolean dataCollectionToken, float delay) {
        if (this.uploadThread != null) {
            Logger.getLogger().d("FirebaseCrashlytics", "Report upload has already been started.");
            return;
        }
        Worker uploadWorker = new Worker(reports, dataCollectionToken, delay);
        this.uploadThread = new Thread((Runnable)uploadWorker, "Crashlytics Report Uploader");
        this.uploadThread.start();
    }

    boolean isUploading() {
        return this.uploadThread != null;
    }

    public boolean uploadReport(Report report, boolean dataCollectionToken) {
        boolean removed = false;
        try {
            boolean shouldDeleteReport;
            CreateReportRequest requestData = new CreateReportRequest(this.organizationId, this.googleAppId, report);
            if (this.isUsingReportsEndpoint || report.getType() == Report.Type.NATIVE) {
                boolean sent = this.createReportCall.invoke(requestData, dataCollectionToken);
                Logger.getLogger().i("FirebaseCrashlytics", "Crashlytics report upload " + (sent ? "complete: " : "FAILED: ") + report.getIdentifier());
                shouldDeleteReport = sent;
            } else {
                Logger.getLogger().d("FirebaseCrashlytics", "Send to reports endpoint disabled. Removing report.");
                shouldDeleteReport = true;
            }
            if (shouldDeleteReport) {
                this.reportManager.deleteReport(report);
                removed = true;
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("FirebaseCrashlytics", "Error occurred sending report " + report, e);
        }
        return removed;
    }

    private class Worker
    extends BackgroundPriorityRunnable {
        private final List<Report> reports;
        private final boolean dataCollectionToken;
        private final float delay;

        Worker(List<Report> reports, boolean dataCollectionToken, float delay) {
            this.reports = reports;
            this.dataCollectionToken = dataCollectionToken;
            this.delay = delay;
        }

        @Override
        public void onRun() {
            try {
                this.attemptUploadWithRetry(this.reports, this.dataCollectionToken);
            }
            catch (Exception e) {
                Logger.getLogger().e("FirebaseCrashlytics", "An unexpected error occurred while attempting to upload crash reports.", e);
            }
            ReportUploader.this.uploadThread = null;
        }

        private void attemptUploadWithRetry(List<Report> reports, boolean dataCollectionToken) {
            Logger.getLogger().d("FirebaseCrashlytics", "Starting report processing in " + this.delay + " second(s)...");
            if (this.delay > 0.0f) {
                try {
                    Thread.sleep((long)(this.delay * 1000.0f));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (ReportUploader.this.handlingExceptionCheck.isHandlingException()) {
                return;
            }
            int retryCount = 0;
            while (reports.size() > 0) {
                if (ReportUploader.this.handlingExceptionCheck.isHandlingException()) {
                    return;
                }
                Logger.getLogger().d("FirebaseCrashlytics", "Attempting to send " + reports.size() + " report(s)");
                ArrayList<Report> remaining = new ArrayList<Report>();
                for (Report report : reports) {
                    boolean removed = ReportUploader.this.uploadReport(report, dataCollectionToken);
                    if (removed) continue;
                    remaining.add(report);
                }
                reports = remaining;
                if (reports.size() <= 0) continue;
                long interval = RETRY_INTERVALS[Math.min(retryCount++, RETRY_INTERVALS.length - 1)];
                Logger.getLogger().d("FirebaseCrashlytics", "Report submission: scheduling delayed retry in " + interval + " seconds");
                try {
                    Thread.sleep(interval * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public static interface ReportFilesProvider {
        public File[] getCompleteSessionFiles();

        public File[] getNativeReportFiles();
    }

    public static interface Provider {
        public ReportUploader createReportUploader(AppSettingsData var1);
    }

    public static interface HandlingExceptionCheck {
        public boolean isHandlingException();
    }
}

