/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.persistence;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$1;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$2;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$3;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$4;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$5;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$6;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class CrashlyticsReportPersistence {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String WORKING_DIRECTORY_NAME = "report-persistence";
    private static final String OPEN_SESSIONS_DIRECTORY_NAME = "sessions";
    private static final String PRIORITY_REPORTS_DIRECTORY = "priority-reports";
    private static final String REPORTS_DIRECTORY = "reports";
    private static final String REPORT_FILE_NAME = "report";
    private static final String USER_FILE_NAME = "user";
    private static final String EVENT_FILE_NAME_PREFIX = "event";
    private static final int EVENT_COUNTER_WIDTH = 10;
    private static final String EVENT_COUNTER_FORMAT = "%010d";
    private static final int EVENT_NAME_LENGTH = "event".length() + 10;
    private static final String PRIORITY_EVENT_SUFFIX = "_";
    private static final String NORMAL_EVENT_SUFFIX = "";
    private static final CrashlyticsReportJsonTransform TRANSFORM = new CrashlyticsReportJsonTransform();
    private static final Comparator<? super File> LATEST_SESSION_ID_FIRST_COMPARATOR = CrashlyticsReportPersistence$$Lambda$6.lambdaFactory$();
    private final AtomicInteger eventCounter = new AtomicInteger(0);
    private final File openSessionsDirectory;
    private final File priorityReportsDirectory;
    private final File reportsDirectory;
    private final int maxEventsToKeep;
    private final int maxReportsToKeep;
    private final int maxOpenSessions;

    public CrashlyticsReportPersistence(File rootDirectory, int maxEventsToKeep, int maxReportsToKeep, int maxOpenSessions) {
        File workingDirectory = new File(rootDirectory, WORKING_DIRECTORY_NAME);
        this.openSessionsDirectory = new File(workingDirectory, OPEN_SESSIONS_DIRECTORY_NAME);
        this.priorityReportsDirectory = new File(workingDirectory, PRIORITY_REPORTS_DIRECTORY);
        this.reportsDirectory = new File(workingDirectory, REPORTS_DIRECTORY);
        this.maxEventsToKeep = maxEventsToKeep;
        this.maxReportsToKeep = maxReportsToKeep;
        this.maxOpenSessions = maxOpenSessions;
    }

    public void persistReport(CrashlyticsReport report) {
        String sessionId = report.getSession().getIdentifier();
        File sessionDirectory = CrashlyticsReportPersistence.prepareDirectory(this.getSessionDirectoryById(sessionId));
        String json = TRANSFORM.reportToJson(report);
        CrashlyticsReportPersistence.writeTextFile(new File(sessionDirectory, REPORT_FILE_NAME), json);
    }

    public void persistEvent(CrashlyticsReport.Session.Event event, String sessionId) {
        this.persistEvent(event, sessionId, false);
    }

    public void persistEvent(CrashlyticsReport.Session.Event event, String sessionId, boolean isHighPriority) {
        File sessionDirectory = this.getSessionDirectoryById(sessionId);
        if (!sessionDirectory.isDirectory()) {
            return;
        }
        String json = TRANSFORM.eventToJson(event);
        String fileName = CrashlyticsReportPersistence.generateEventFilename(this.eventCounter.getAndIncrement(), isHighPriority);
        CrashlyticsReportPersistence.writeTextFile(new File(sessionDirectory, fileName), json);
        CrashlyticsReportPersistence.trimEvents(sessionDirectory, this.maxEventsToKeep);
    }

    public void persistUserIdForSession(String userId, String sessionId) {
        File sessionDirectory = this.getSessionDirectoryById(sessionId);
        if (!sessionDirectory.isDirectory()) {
            return;
        }
        CrashlyticsReportPersistence.writeTextFile(new File(sessionDirectory, USER_FILE_NAME), userId);
    }

    public void deleteAllReports() {
        for (File reportFile : this.getAllFinalizedReportFiles()) {
            reportFile.delete();
        }
    }

    public void deleteFinalizedReport(String sessionId) {
        FilenameFilter filter = CrashlyticsReportPersistence$$Lambda$1.lambdaFactory$(sessionId);
        List<File> filteredReports = CrashlyticsReportPersistence.sortAndCombineReportFiles(CrashlyticsReportPersistence.getFilesInDirectory(this.priorityReportsDirectory, filter), CrashlyticsReportPersistence.getFilesInDirectory(this.reportsDirectory, filter));
        for (File reportFile : filteredReports) {
            reportFile.delete();
        }
    }

    public void finalizeReports(String currentSessionId) {
        List<File> sessionDirectories = this.capAndGetOpenSessions(currentSessionId);
        for (File sessionDirectory : sessionDirectories) {
            List<File> eventFiles = CrashlyticsReportPersistence.getFilesInDirectory(sessionDirectory, CrashlyticsReportPersistence$$Lambda$2.lambdaFactory$());
            Collections.sort(eventFiles);
            if (!eventFiles.isEmpty()) {
                ArrayList<CrashlyticsReport.Session.Event> events = new ArrayList<CrashlyticsReport.Session.Event>();
                boolean isHighPriorityReport = false;
                for (File eventFile : eventFiles) {
                    CrashlyticsReport.Session.Event event = TRANSFORM.eventFromJson(CrashlyticsReportPersistence.readTextFile(eventFile));
                    isHighPriorityReport = isHighPriorityReport || CrashlyticsReportPersistence.isHighPriorityEventFile(eventFile.getName());
                    events.add(event);
                }
                String userId = null;
                File userFile = new File(sessionDirectory, USER_FILE_NAME);
                if (userFile.exists()) {
                    userId = CrashlyticsReportPersistence.readTextFile(userFile);
                }
                CrashlyticsReport report = TRANSFORM.reportFromJson(CrashlyticsReportPersistence.readTextFile(new File(sessionDirectory, REPORT_FILE_NAME)));
                String sessionId = report.getSession().getIdentifier();
                if (userId != null) {
                    report = report.withUserId(userId);
                }
                File outputDirectory = CrashlyticsReportPersistence.prepareDirectory(isHighPriorityReport ? this.priorityReportsDirectory : this.reportsDirectory);
                CrashlyticsReportPersistence.writeTextFile(new File(outputDirectory, sessionId), TRANSFORM.reportToJson(report.withEvents(ImmutableList.from(events))));
            }
            CrashlyticsReportPersistence.recursiveDelete(sessionDirectory);
        }
        this.capFinalizedReports();
    }

    public List<CrashlyticsReport> loadFinalizedReports() {
        List<File> allReportFiles = this.getAllFinalizedReportFiles();
        ArrayList<CrashlyticsReport> allReports = new ArrayList<CrashlyticsReport>();
        allReports.ensureCapacity(allReportFiles.size());
        for (File reportFile : this.getAllFinalizedReportFiles()) {
            allReports.add(TRANSFORM.reportFromJson(CrashlyticsReportPersistence.readTextFile(reportFile)));
        }
        return allReports;
    }

    private List<File> capAndGetOpenSessions(String currentSessionId) {
        FileFilter sessionDirectoryFilter = CrashlyticsReportPersistence$$Lambda$3.lambdaFactory$(currentSessionId);
        List<File> openSessionDirectories = CrashlyticsReportPersistence.getFilesInDirectory(this.openSessionsDirectory, sessionDirectoryFilter);
        Collections.sort(openSessionDirectories, LATEST_SESSION_ID_FIRST_COMPARATOR);
        if (openSessionDirectories.size() <= this.maxOpenSessions) {
            return openSessionDirectories;
        }
        List<File> openSessionDirectoriesToRemove = openSessionDirectories.subList(this.maxOpenSessions, openSessionDirectories.size());
        for (File openSessionDirectory : openSessionDirectoriesToRemove) {
            CrashlyticsReportPersistence.recursiveDelete(openSessionDirectory);
        }
        return openSessionDirectories.subList(0, this.maxOpenSessions);
    }

    private void capFinalizedReports() {
        List<File> finalizedReportFiles = this.getAllFinalizedReportFiles();
        int fileCount = finalizedReportFiles.size();
        if (fileCount <= this.maxReportsToKeep) {
            return;
        }
        List<File> filesToRemove = finalizedReportFiles.subList(this.maxReportsToKeep, fileCount);
        for (File reportFile : filesToRemove) {
            reportFile.delete();
        }
    }

    @NonNull
    private List<File> getAllFinalizedReportFiles() {
        return CrashlyticsReportPersistence.sortAndCombineReportFiles(CrashlyticsReportPersistence.getAllFilesInDirectory(this.priorityReportsDirectory), CrashlyticsReportPersistence.getAllFilesInDirectory(this.reportsDirectory));
    }

    @NonNull
    private static List<File> sortAndCombineReportFiles(List<File> priorityReports, List<File> reports) {
        Collections.sort(priorityReports, LATEST_SESSION_ID_FIRST_COMPARATOR);
        Collections.sort(reports, LATEST_SESSION_ID_FIRST_COMPARATOR);
        ArrayList<File> allReportsFiles = new ArrayList<File>();
        allReportsFiles.ensureCapacity(priorityReports.size() + reports.size());
        allReportsFiles.addAll(priorityReports);
        allReportsFiles.addAll(reports);
        return allReportsFiles;
    }

    private static boolean isHighPriorityEventFile(String fileName) {
        return fileName.startsWith(EVENT_FILE_NAME_PREFIX) && fileName.endsWith(PRIORITY_EVENT_SUFFIX);
    }

    private static boolean isNormalPriorityEventFile(File dir, String name) {
        return name.startsWith(EVENT_FILE_NAME_PREFIX) && !name.endsWith(PRIORITY_EVENT_SUFFIX);
    }

    private File getSessionDirectoryById(String sessionId) {
        return new File(this.openSessionsDirectory, sessionId);
    }

    private static String generateEventFilename(int eventNumber, boolean isHighPriority) {
        String paddedEventNumber = String.format(Locale.US, EVENT_COUNTER_FORMAT, eventNumber);
        String prioritySuffix = isHighPriority ? PRIORITY_EVENT_SUFFIX : NORMAL_EVENT_SUFFIX;
        return EVENT_FILE_NAME_PREFIX + paddedEventNumber + prioritySuffix;
    }

    private static int trimEvents(File sessionDirectory, int maximum) {
        List<File> normalPriorityEventFiles = CrashlyticsReportPersistence.getFilesInDirectory(sessionDirectory, CrashlyticsReportPersistence$$Lambda$4.lambdaFactory$());
        Collections.sort(normalPriorityEventFiles, CrashlyticsReportPersistence$$Lambda$5.lambdaFactory$());
        return CrashlyticsReportPersistence.capFilesCount(normalPriorityEventFiles, maximum);
    }

    private static String getEventNameWithoutPriority(String eventFileName) {
        return eventFileName.substring(0, EVENT_NAME_LENGTH);
    }

    private static int oldestEventFileFirst(File f1, File f2) {
        String name1 = CrashlyticsReportPersistence.getEventNameWithoutPriority(f1.getName());
        String name2 = CrashlyticsReportPersistence.getEventNameWithoutPriority(f2.getName());
        return name1.compareTo(name2);
    }

    private static List<File> getAllFilesInDirectory(File directory) {
        return CrashlyticsReportPersistence.getFilesInDirectory(directory, (FileFilter)null);
    }

    private static List<File> getFilesInDirectory(File directory, FilenameFilter filter) {
        if (directory == null || !directory.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    private static List<File> getFilesInDirectory(File directory, FileFilter filter) {
        if (directory == null || !directory.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    private static File prepareDirectory(File directory) {
        if (directory == null) {
            return null;
        }
        if (directory.exists() || directory.mkdirs()) {
            return directory;
        }
        return null;
    }

    private static void writeTextFile(File file, String text) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8);
            Throwable throwable = null;
            try {
                writer.write(text);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CrashlyticsReportPersistence.$closeResource(throwable, writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readTextFile(File file) {
        String string;
        byte[] readBuffer = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream fileInput = new FileInputStream(file);
        Throwable throwable = null;
        try {
            int read;
            while ((read = fileInput.read(readBuffer)) > 0) {
                bos.write(readBuffer, 0, read);
            }
            string = new String(bos.toByteArray(), UTF_8);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CrashlyticsReportPersistence.$closeResource(throwable, fileInput);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        CrashlyticsReportPersistence.$closeResource(throwable, fileInput);
        return string;
    }

    private static int capFilesCount(List<File> files, int maximum) {
        int numRetained = files.size();
        for (File f : files) {
            if (numRetained <= maximum) {
                return numRetained;
            }
            CrashlyticsReportPersistence.recursiveDelete(f);
            --numRetained;
        }
        return numRetained;
    }

    private static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                CrashlyticsReportPersistence.recursiveDelete(f);
            }
        }
        file.delete();
    }

    static /* synthetic */ boolean lambda$capAndGetOpenSessions$3(String currentSessionId, File f) {
        return f.isDirectory() && !f.getName().equals(currentSessionId);
    }

    static /* synthetic */ boolean lambda$finalizeReports$2(File f, String name) {
        return name.startsWith(EVENT_FILE_NAME_PREFIX);
    }

    static /* synthetic */ boolean lambda$deleteFinalizedReport$1(String sessionId, File d, String f) {
        return f.startsWith(sessionId);
    }

    static /* synthetic */ int lambda$static$0(File f1, File f2) {
        return f2.getName().compareTo(f1.getName());
    }

    private static /* synthetic */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
            }
        } else {
            x1.close();
        }
    }

    static /* synthetic */ boolean access$lambda$0(File file, String string) {
        return CrashlyticsReportPersistence.isNormalPriorityEventFile(file, string);
    }

    static /* synthetic */ int access$lambda$1(File file, File file2) {
        return CrashlyticsReportPersistence.oldestEventFileFirst(file, file2);
    }
}

