/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.network;

import com.google.firebase.crashlytics.internal.network.HttpMethod;
import com.google.firebase.crashlytics.internal.network.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class HttpRequest {
    private static final OkHttpClient CLIENT = new OkHttpClient().newBuilder().callTimeout(10000L, TimeUnit.MILLISECONDS).build();
    private static final int DEFAULT_TIMEOUT_MS = 10000;
    private final HttpMethod method;
    private final String url;
    private final Map<String, String> queryParams;
    private final Map<String, String> headers;
    private MultipartBody.Builder bodyBuilder = null;

    public HttpRequest(HttpMethod method, String url, Map<String, String> queryParams) {
        this.method = method;
        this.url = url;
        this.queryParams = queryParams;
        this.headers = new HashMap<String, String>();
    }

    public HttpRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequest header(Map.Entry<String, String> entry) {
        return this.header(entry.getKey(), entry.getValue());
    }

    private MultipartBody.Builder getOrCreateBodyBuilder() {
        if (this.bodyBuilder == null) {
            this.bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        }
        return this.bodyBuilder;
    }

    public HttpRequest part(String name, String value) {
        this.bodyBuilder = this.getOrCreateBodyBuilder().addFormDataPart(name, value);
        return this;
    }

    public HttpRequest part(String name, String filename, String contentType, File part) {
        MediaType type = MediaType.parse((String)contentType);
        RequestBody body = RequestBody.create((MediaType)type, (File)part);
        this.bodyBuilder = this.getOrCreateBodyBuilder().addFormDataPart(name, filename, body);
        return this;
    }

    public String method() {
        return this.method.name();
    }

    private Request build() {
        Request.Builder builder = new Request.Builder().cacheControl(new CacheControl.Builder().noCache().build());
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.url).newBuilder();
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            urlBuilder = urlBuilder.addEncodedQueryParameter(entry.getKey(), entry.getValue());
        }
        builder = builder.url(urlBuilder.build());
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            builder = builder.header(entry.getKey(), entry.getValue());
        }
        MultipartBody body = this.bodyBuilder == null ? null : this.bodyBuilder.build();
        builder = builder.method(this.method.name(), (RequestBody)body);
        return builder.build();
    }

    public HttpResponse execute() throws IOException {
        Request request = this.build();
        Call call = CLIENT.newCall(request);
        return HttpResponse.create(call.execute());
    }
}

