/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model.serialization;

import android.util.Base64;
import android.util.JsonReader;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.model.AutoCrashlyticsReportEncoder;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$Lambda$1;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$Lambda$2;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$Lambda$3;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$Lambda$4;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$Lambda$5;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$Lambda$6;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class CrashlyticsReportJsonTransform {
    private static final DataEncoder CRASHLYTICS_REPORT_JSON_ENCODER = new JsonDataEncoderBuilder().configureWith(AutoCrashlyticsReportEncoder.CONFIG).ignoreNullValues(true).build();

    @NonNull
    public String reportToJson(@NonNull CrashlyticsReport report) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode((Object)report);
    }

    @NonNull
    public String eventToJson(@NonNull CrashlyticsReport.Session.Event event) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode((Object)event);
    }

    @Nullable
    public CrashlyticsReport reportFromJson(@Nullable String json) {
        CrashlyticsReport crashlyticsReport;
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
        Throwable throwable = null;
        try {
            crashlyticsReport = CrashlyticsReportJsonTransform.parseReport(jsonReader);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CrashlyticsReportJsonTransform.$closeResource(throwable, (AutoCloseable)jsonReader);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        CrashlyticsReportJsonTransform.$closeResource(throwable, (AutoCloseable)jsonReader);
        return crashlyticsReport;
    }

    @Nullable
    public CrashlyticsReport.Session.Event eventFromJson(@NonNull String json) {
        CrashlyticsReport.Session.Event event;
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
        Throwable throwable = null;
        try {
            event = CrashlyticsReportJsonTransform.parseEvent(jsonReader);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CrashlyticsReportJsonTransform.$closeResource(throwable, (AutoCloseable)jsonReader);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        CrashlyticsReportJsonTransform.$closeResource(throwable, (AutoCloseable)jsonReader);
        return event;
    }

    private static CrashlyticsReport parseReport(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Builder builder = CrashlyticsReport.builder();
        jsonReader.beginObject();
        block18: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case -1962630338: {
                    if (!string.equals("sdkVersion")) break;
                    n = 0;
                    break;
                }
                case 344431858: {
                    if (!string.equals("gmpAppId")) break;
                    n = 1;
                    break;
                }
                case 1874684019: {
                    if (!string.equals("platform")) break;
                    n = 2;
                    break;
                }
                case 719853845: {
                    if (!string.equals("installationUuid")) break;
                    n = 3;
                    break;
                }
                case -911706486: {
                    if (!string.equals("buildVersion")) break;
                    n = 4;
                    break;
                }
                case 1975623094: {
                    if (!string.equals("displayVersion")) break;
                    n = 5;
                    break;
                }
                case 1984987798: {
                    if (!string.equals("session")) break;
                    n = 6;
                }
            }
            switch (n) {
                case 0: {
                    builder.setSdkVersion(jsonReader.nextString());
                    continue block18;
                }
                case 1: {
                    builder.setGmpAppId(jsonReader.nextString());
                    continue block18;
                }
                case 2: {
                    builder.setPlatform(jsonReader.nextInt());
                    continue block18;
                }
                case 3: {
                    builder.setInstallationUuid(jsonReader.nextString());
                    continue block18;
                }
                case 4: {
                    builder.setBuildVersion(jsonReader.nextString());
                    continue block18;
                }
                case 5: {
                    builder.setDisplayVersion(jsonReader.nextString());
                    continue block18;
                }
                case 6: {
                    builder.setSession(CrashlyticsReportJsonTransform.parseSession(jsonReader));
                    continue block18;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session parseSession(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Builder builder = CrashlyticsReport.Session.builder();
        jsonReader.beginObject();
        block20: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 286956243: {
                    if (!string.equals("generator")) break;
                    n = 0;
                    break;
                }
                case -1618432855: {
                    if (!string.equals("identifier")) break;
                    n = 1;
                    break;
                }
                case -2128794476: {
                    if (!string.equals("startedAt")) break;
                    n = 2;
                    break;
                }
                case 3599307: {
                    if (!string.equals("user")) break;
                    n = 3;
                    break;
                }
                case 96801: {
                    if (!string.equals("app")) break;
                    n = 4;
                    break;
                }
                case 3556: {
                    if (!string.equals("os")) break;
                    n = 5;
                    break;
                }
                case -1335157162: {
                    if (!string.equals("device")) break;
                    n = 6;
                    break;
                }
                case -1291329255: {
                    if (!string.equals("events")) break;
                    n = 7;
                }
            }
            switch (n) {
                case 0: {
                    builder.setGenerator(jsonReader.nextString());
                    continue block20;
                }
                case 1: {
                    builder.setIdentifierFromUtf8Bytes(Base64.decode((String)jsonReader.nextString(), (int)2));
                    continue block20;
                }
                case 2: {
                    builder.setStartedAt(jsonReader.nextLong());
                    continue block20;
                }
                case 3: {
                    builder.setUser(CrashlyticsReportJsonTransform.parseUser(jsonReader));
                    continue block20;
                }
                case 4: {
                    builder.setApp(CrashlyticsReportJsonTransform.parseApp(jsonReader));
                    continue block20;
                }
                case 5: {
                    builder.setOs(CrashlyticsReportJsonTransform.parseOs(jsonReader));
                    continue block20;
                }
                case 6: {
                    builder.setDevice(CrashlyticsReportJsonTransform.parseDevice(jsonReader));
                    continue block20;
                }
                case 7: {
                    builder.setEvents(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$Lambda$1.lambdaFactory$()));
                    continue block20;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.User parseUser(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.User.Builder builder = CrashlyticsReport.Session.User.builder();
        jsonReader.beginObject();
        block6: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case -1618432855: {
                    if (!string.equals("identifier")) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    builder.setIdentifier(jsonReader.nextString());
                    continue block6;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Application parseApp(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Application.Builder builder = CrashlyticsReport.Session.Application.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case -1618432855: {
                    if (!string.equals("identifier")) break;
                    n = 0;
                    break;
                }
                case 351608024: {
                    if (!string.equals("version")) break;
                    n = 1;
                    break;
                }
                case 1975623094: {
                    if (!string.equals("displayVersion")) break;
                    n = 2;
                    break;
                }
                case 719853845: {
                    if (!string.equals("installationUuid")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    builder.setIdentifier(jsonReader.nextString());
                    continue block12;
                }
                case 1: {
                    builder.setVersion(jsonReader.nextString());
                    continue block12;
                }
                case 2: {
                    builder.setDisplayVersion(jsonReader.nextString());
                    continue block12;
                }
                case 3: {
                    builder.setInstallationUuid(jsonReader.nextString());
                    continue block12;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.OperatingSystem parseOs(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.OperatingSystem.Builder builder = CrashlyticsReport.Session.OperatingSystem.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 1874684019: {
                    if (!string.equals("platform")) break;
                    n = 0;
                    break;
                }
                case 351608024: {
                    if (!string.equals("version")) break;
                    n = 1;
                    break;
                }
                case -911706486: {
                    if (!string.equals("buildVersion")) break;
                    n = 2;
                    break;
                }
                case -293026577: {
                    if (!string.equals("jailbroken")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    builder.setPlatform(jsonReader.nextInt());
                    continue block12;
                }
                case 1: {
                    builder.setVersion(jsonReader.nextString());
                    continue block12;
                }
                case 2: {
                    builder.setBuildVersion(jsonReader.nextString());
                    continue block12;
                }
                case 3: {
                    builder.setJailbroken(jsonReader.nextBoolean());
                    continue block12;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Device parseDevice(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Device.Builder builder = CrashlyticsReport.Session.Device.builder();
        jsonReader.beginObject();
        block22: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 3002454: {
                    if (!string.equals("arch")) break;
                    n = 0;
                    break;
                }
                case 104069929: {
                    if (!string.equals("model")) break;
                    n = 1;
                    break;
                }
                case 94848180: {
                    if (!string.equals("cores")) break;
                    n = 2;
                    break;
                }
                case 112670: {
                    if (!string.equals("ram")) break;
                    n = 3;
                    break;
                }
                case 81784169: {
                    if (!string.equals("diskSpace")) break;
                    n = 4;
                    break;
                }
                case -1981332476: {
                    if (!string.equals("simulator")) break;
                    n = 5;
                    break;
                }
                case 109757585: {
                    if (!string.equals("state")) break;
                    n = 6;
                    break;
                }
                case -1969347631: {
                    if (!string.equals("manufacturer")) break;
                    n = 7;
                    break;
                }
                case 2078953423: {
                    if (!string.equals("modelClass")) break;
                    n = 8;
                }
            }
            switch (n) {
                case 0: {
                    builder.setArch(jsonReader.nextInt());
                    continue block22;
                }
                case 1: {
                    builder.setModel(jsonReader.nextString());
                    continue block22;
                }
                case 2: {
                    builder.setCores(jsonReader.nextInt());
                    continue block22;
                }
                case 3: {
                    builder.setRam(jsonReader.nextLong());
                    continue block22;
                }
                case 4: {
                    builder.setDiskSpace(jsonReader.nextLong());
                    continue block22;
                }
                case 5: {
                    builder.setSimulator(jsonReader.nextBoolean());
                    continue block22;
                }
                case 6: {
                    builder.setState(jsonReader.nextInt());
                    continue block22;
                }
                case 7: {
                    builder.setManufacturer(jsonReader.nextString());
                    continue block22;
                }
                case 8: {
                    builder.setModelClass(jsonReader.nextString());
                    continue block22;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event parseEvent(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Builder builder = CrashlyticsReport.Session.Event.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 55126294: {
                    if (!string.equals("timestamp")) break;
                    n = 0;
                    break;
                }
                case 3575610: {
                    if (!string.equals("type")) break;
                    n = 1;
                    break;
                }
                case 96801: {
                    if (!string.equals("app")) break;
                    n = 2;
                    break;
                }
                case -1335157162: {
                    if (!string.equals("device")) break;
                    n = 3;
                    break;
                }
                case 107332: {
                    if (!string.equals("log")) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: {
                    builder.setTimestamp(jsonReader.nextLong());
                    continue block14;
                }
                case 1: {
                    builder.setType(jsonReader.nextString());
                    continue block14;
                }
                case 2: {
                    builder.setApp(CrashlyticsReportJsonTransform.parseEventApp(jsonReader));
                    continue block14;
                }
                case 3: {
                    builder.setDevice(CrashlyticsReportJsonTransform.parseEventDevice(jsonReader));
                    continue block14;
                }
                case 4: {
                    builder.setLog(CrashlyticsReportJsonTransform.parseEventLog(jsonReader));
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application parseEventApp(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Builder builder = CrashlyticsReport.Session.Event.Application.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case -1332194002: {
                    if (!string.equals("background")) break;
                    n = 0;
                    break;
                }
                case 928737948: {
                    if (!string.equals("uiOrientation")) break;
                    n = 1;
                    break;
                }
                case -1090974952: {
                    if (!string.equals("execution")) break;
                    n = 2;
                    break;
                }
                case 555169704: {
                    if (!string.equals("customAttributes")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    builder.setBackground(jsonReader.nextBoolean());
                    continue block12;
                }
                case 1: {
                    builder.setUiOrientation(jsonReader.nextInt());
                    continue block12;
                }
                case 2: {
                    builder.setExecution(CrashlyticsReportJsonTransform.parseEventExecution(jsonReader));
                    continue block12;
                }
                case 3: {
                    builder.setCustomAttributes(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$Lambda$2.lambdaFactory$()));
                    continue block12;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution parseEventExecution(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case -1337936983: {
                    if (!string.equals("threads")) break;
                    n = 0;
                    break;
                }
                case 1481625679: {
                    if (!string.equals("exception")) break;
                    n = 1;
                    break;
                }
                case -902467928: {
                    if (!string.equals("signal")) break;
                    n = 2;
                    break;
                }
                case 937615455: {
                    if (!string.equals("binaries")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    builder.setThreads(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$Lambda$3.lambdaFactory$()));
                    continue block12;
                }
                case 1: {
                    builder.setException(CrashlyticsReportJsonTransform.parseEventExecutionException(jsonReader));
                    continue block12;
                }
                case 2: {
                    builder.setSignal(CrashlyticsReportJsonTransform.parseEventSignal(jsonReader));
                    continue block12;
                }
                case 3: {
                    builder.setBinaries(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$Lambda$4.lambdaFactory$()));
                    continue block12;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Exception parseEventExecutionException(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Exception.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Exception.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 91997906: {
                    if (!string.equals("causedBy")) break;
                    n = 0;
                    break;
                }
                case -1266514778: {
                    if (!string.equals("frames")) break;
                    n = 1;
                    break;
                }
                case 581754413: {
                    if (!string.equals("overflowCount")) break;
                    n = 2;
                    break;
                }
                case 3575610: {
                    if (!string.equals("type")) break;
                    n = 3;
                    break;
                }
                case -934964668: {
                    if (!string.equals("reason")) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: {
                    builder.setCausedBy(CrashlyticsReportJsonTransform.parseEventExecutionException(jsonReader));
                    continue block14;
                }
                case 1: {
                    builder.setFrames(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$Lambda$5.lambdaFactory$()));
                    continue block14;
                }
                case 2: {
                    builder.setOverflowCount(jsonReader.nextInt());
                    continue block14;
                }
                case 3: {
                    builder.setType(jsonReader.nextString());
                    continue block14;
                }
                case 4: {
                    builder.setReason(jsonReader.nextString());
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Signal parseEventSignal(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Signal.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Signal.builder();
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals("name")) break;
                    n = 0;
                    break;
                }
                case 3059181: {
                    if (!string.equals("code")) break;
                    n = 1;
                    break;
                }
                case -1147692044: {
                    if (!string.equals("address")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    builder.setName(jsonReader.nextString());
                    continue block10;
                }
                case 1: {
                    builder.setCode(jsonReader.nextString());
                    continue block10;
                }
                case 2: {
                    builder.setAddress(jsonReader.nextLong());
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.BinaryImage parseEventBinaryImage(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals("name")) break;
                    n = 0;
                    break;
                }
                case 1153765347: {
                    if (!string.equals("baseAddress")) break;
                    n = 1;
                    break;
                }
                case 3530753: {
                    if (!string.equals("size")) break;
                    n = 2;
                    break;
                }
                case 3601339: {
                    if (!string.equals("uuid")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    builder.setName(jsonReader.nextString());
                    continue block12;
                }
                case 1: {
                    builder.setBaseAddress(jsonReader.nextLong());
                    continue block12;
                }
                case 2: {
                    builder.setSize(jsonReader.nextLong());
                    continue block12;
                }
                case 3: {
                    builder.setUuidFromUtf8Bytes(Base64.decode((String)jsonReader.nextString(), (int)2));
                    continue block12;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Thread parseEventThread(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Thread.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Thread.builder();
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 2125650548: {
                    if (!string.equals("importance")) break;
                    n = 0;
                    break;
                }
                case 3373707: {
                    if (!string.equals("name")) break;
                    n = 1;
                    break;
                }
                case -1266514778: {
                    if (!string.equals("frames")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    builder.setImportance(jsonReader.nextInt());
                    continue block10;
                }
                case 1: {
                    builder.setName(jsonReader.nextString());
                    continue block10;
                }
                case 2: {
                    builder.setFrames(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$Lambda$6.lambdaFactory$()));
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame parseEventFrame(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 2125650548: {
                    if (!string.equals("importance")) break;
                    n = 0;
                    break;
                }
                case 3143036: {
                    if (!string.equals("file")) break;
                    n = 1;
                    break;
                }
                case -1019779949: {
                    if (!string.equals("offset")) break;
                    n = 2;
                    break;
                }
                case 3571: {
                    if (!string.equals("pc")) break;
                    n = 3;
                    break;
                }
                case -887523944: {
                    if (!string.equals("symbol")) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: {
                    builder.setImportance(jsonReader.nextInt());
                    continue block14;
                }
                case 1: {
                    builder.setFile(jsonReader.nextString());
                    continue block14;
                }
                case 2: {
                    builder.setOffset(jsonReader.nextLong());
                    continue block14;
                }
                case 3: {
                    builder.setPc(jsonReader.nextLong());
                    continue block14;
                }
                case 4: {
                    builder.setSymbol(jsonReader.nextString());
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Device parseEventDevice(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Device.Builder builder = CrashlyticsReport.Session.Event.Device.builder();
        jsonReader.beginObject();
        block16: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case -1708606089: {
                    if (!string.equals("batteryLevel")) break;
                    n = 0;
                    break;
                }
                case -1455558134: {
                    if (!string.equals("batteryVelocity")) break;
                    n = 1;
                    break;
                }
                case 279795450: {
                    if (!string.equals("diskUsed")) break;
                    n = 2;
                    break;
                }
                case 1516795582: {
                    if (!string.equals("proximityOn")) break;
                    n = 3;
                    break;
                }
                case -1439500848: {
                    if (!string.equals("orientation")) break;
                    n = 4;
                    break;
                }
                case 976541947: {
                    if (!string.equals("ramUsed")) break;
                    n = 5;
                }
            }
            switch (n) {
                case 0: {
                    builder.setBatteryLevel(jsonReader.nextDouble());
                    continue block16;
                }
                case 1: {
                    builder.setBatteryVelocity(jsonReader.nextInt());
                    continue block16;
                }
                case 2: {
                    builder.setDiskUsed(jsonReader.nextLong());
                    continue block16;
                }
                case 3: {
                    builder.setProximityOn(jsonReader.nextBoolean());
                    continue block16;
                }
                case 4: {
                    builder.setOrientation(jsonReader.nextInt());
                    continue block16;
                }
                case 5: {
                    builder.setRamUsed(jsonReader.nextLong());
                    continue block16;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Log parseEventLog(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Log.Builder builder = CrashlyticsReport.Session.Event.Log.builder();
        jsonReader.beginObject();
        block6: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 951530617: {
                    if (!string.equals("content")) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    builder.setContent(jsonReader.nextString());
                    continue block6;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.CustomAttribute parseCustomAttribute(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.CustomAttribute.Builder builder = CrashlyticsReport.CustomAttribute.builder();
        jsonReader.beginObject();
        block8: while (jsonReader.hasNext()) {
            String name;
            String string = name = jsonReader.nextName();
            int n = -1;
            switch (string.hashCode()) {
                case 106079: {
                    if (!string.equals("key")) break;
                    n = 0;
                    break;
                }
                case 111972721: {
                    if (!string.equals("value")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    builder.setKey(jsonReader.nextString());
                    continue block8;
                }
                case 1: {
                    builder.setValue(jsonReader.nextString());
                    continue block8;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static <T> ImmutableList<T> parseArray(JsonReader jsonReader, ObjectParser<T> objectParser) throws IOException {
        ArrayList<T> objects = new ArrayList<T>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            objects.add(objectParser.parse(jsonReader));
        }
        jsonReader.endArray();
        return ImmutableList.from(objects);
    }

    private static /* synthetic */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
            }
        } else {
            x1.close();
        }
    }

    static /* synthetic */ CrashlyticsReport.Session.Event access$lambda$0(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEvent(jsonReader);
    }

    static /* synthetic */ CrashlyticsReport.CustomAttribute access$lambda$1(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseCustomAttribute(jsonReader);
    }

    static /* synthetic */ CrashlyticsReport.Session.Event.Application.Execution.Thread access$lambda$2(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEventThread(jsonReader);
    }

    static /* synthetic */ CrashlyticsReport.Session.Event.Application.Execution.BinaryImage access$lambda$3(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEventBinaryImage(jsonReader);
    }

    static /* synthetic */ CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame access$lambda$4(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEventFrame(jsonReader);
    }

    static /* synthetic */ CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame access$lambda$5(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEventFrame(jsonReader);
    }

    private static interface ObjectParser<T> {
        public T parse(JsonReader var1) throws IOException;
    }
}

