/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import com.google.firebase.crashlytics.internal.common.CurrentTimeProvider;
import com.google.firebase.crashlytics.internal.settings.SettingsJsonTransform;
import com.google.firebase.crashlytics.internal.settings.model.AppSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.FeaturesSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.SessionSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.Settings;
import com.google.firebase.crashlytics.internal.settings.model.SettingsData;
import org.json.JSONException;
import org.json.JSONObject;

class DefaultSettingsJsonTransform
implements SettingsJsonTransform {
    DefaultSettingsJsonTransform() {
    }

    @Override
    public SettingsData buildFromJson(CurrentTimeProvider currentTimeProvider, JSONObject json) throws JSONException {
        int settingsVersion = json.optInt("settings_version", 0);
        int cacheDuration = json.optInt("cache_duration", 3600);
        AppSettingsData appData = DefaultSettingsJsonTransform.buildAppDataFrom(json.getJSONObject("app"));
        SessionSettingsData settingsData = DefaultSettingsJsonTransform.buildSessionDataFrom(json.getJSONObject("session"));
        FeaturesSettingsData featureData = DefaultSettingsJsonTransform.buildFeaturesSessionDataFrom(json.getJSONObject("features"));
        long expiresAtMillis = DefaultSettingsJsonTransform.getExpiresAtFrom(currentTimeProvider, cacheDuration, json);
        return new SettingsData(expiresAtMillis, appData, settingsData, featureData, settingsVersion, cacheDuration);
    }

    static Settings defaultSettings(CurrentTimeProvider currentTimeProvider) {
        boolean settingsVersion = false;
        int cacheDuration = 3600;
        JSONObject empty = new JSONObject();
        AppSettingsData appData = null;
        SessionSettingsData settingsData = DefaultSettingsJsonTransform.buildSessionDataFrom(empty);
        FeaturesSettingsData featureData = DefaultSettingsJsonTransform.buildFeaturesSessionDataFrom(empty);
        long expiresAtMillis = DefaultSettingsJsonTransform.getExpiresAtFrom(currentTimeProvider, 3600L, empty);
        return new SettingsData(expiresAtMillis, appData, settingsData, featureData, 0, 3600);
    }

    @Override
    public JSONObject toJson(SettingsData settingsData) throws JSONException {
        return new JSONObject().put("expires_at", settingsData.expiresAtMillis).put("cache_duration", settingsData.cacheDuration).put("settings_version", settingsData.settingsVersion).put("features", (Object)this.toFeaturesJson(settingsData.featuresData)).put("app", (Object)this.toAppJson(settingsData.appData)).put("session", (Object)this.toSessionJson(settingsData.sessionData));
    }

    private static AppSettingsData buildAppDataFrom(JSONObject json) throws JSONException {
        String status = json.getString("status");
        String url = json.getString("url");
        String reportsUrl = json.getString("reports_url");
        String ndkReportsUrl = json.getString("ndk_reports_url");
        boolean updateRequired = json.optBoolean("update_required", false);
        return new AppSettingsData(status, url, reportsUrl, ndkReportsUrl, updateRequired);
    }

    private static FeaturesSettingsData buildFeaturesSessionDataFrom(JSONObject json) {
        boolean collectReports = json.optBoolean("collect_reports", true);
        return new FeaturesSettingsData(collectReports);
    }

    private static SessionSettingsData buildSessionDataFrom(JSONObject json) {
        int maxCustomExceptionEvents = json.optInt("max_custom_exception_events", 8);
        int maxCompleteSessionsCount = 4;
        return new SessionSettingsData(maxCustomExceptionEvents, 4);
    }

    private static long getExpiresAtFrom(CurrentTimeProvider currentTimeProvider, long cacheDurationSeconds, JSONObject json) {
        long expiresAtMillis = 0L;
        if (json.has("expires_at")) {
            expiresAtMillis = json.optLong("expires_at");
        } else {
            long currentTimeMillis = currentTimeProvider.getCurrentTimeMillis();
            expiresAtMillis = currentTimeMillis + cacheDurationSeconds * 1000L;
        }
        return expiresAtMillis;
    }

    private JSONObject toAppJson(AppSettingsData appData) throws JSONException {
        JSONObject json = new JSONObject().put("status", (Object)appData.status).put("url", (Object)appData.url).put("reports_url", (Object)appData.reportsUrl).put("ndk_reports_url", (Object)appData.ndkReportsUrl).put("update_required", appData.updateRequired);
        return json;
    }

    private JSONObject toFeaturesJson(FeaturesSettingsData features) throws JSONException {
        return new JSONObject().put("collect_reports", features.collectReports);
    }

    private JSONObject toSessionJson(SessionSettingsData data) throws JSONException {
        return new JSONObject().put("max_custom_exception_events", data.maxCustomExceptionEvents).put("max_complete_sessions_count", data.maxCompleteSessionsCount);
    }
}

