/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import android.content.Context;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.persistence.FileStoreImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import org.json.JSONObject;

public class CachedSettingsIo {
    private static final String SETTINGS_CACHE_FILENAME = "com.crashlytics.settings.json";
    private final Context context;

    public CachedSettingsIo(Context context) {
        this.context = context;
    }

    private File getSettingsFile() {
        return new File(new FileStoreImpl(this.context).getFilesDir(), SETTINGS_CACHE_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject readCachedSettings() {
        JSONObject toReturn;
        FileInputStream fis;
        block5: {
            Logger.getLogger().d("FirebaseCrashlytics", "Reading cached settings...");
            fis = null;
            toReturn = null;
            try {
                File settingsFile = this.getSettingsFile();
                if (settingsFile.exists()) {
                    fis = new FileInputStream(settingsFile);
                    String settingsStr = CommonUtils.streamToString(fis);
                    toReturn = new JSONObject(settingsStr);
                    break block5;
                }
                Logger.getLogger().d("FirebaseCrashlytics", "No cached settings found.");
            }
            catch (Exception e) {
                try {
                    Logger.getLogger().e("FirebaseCrashlytics", "Failed to fetch cached settings", e);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeOrLog(fis, "Error while closing settings cache file.");
                    throw throwable;
                }
                CommonUtils.closeOrLog(fis, "Error while closing settings cache file.");
            }
        }
        CommonUtils.closeOrLog(fis, "Error while closing settings cache file.");
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCachedSettings(long expiresAtMillis, JSONObject settingsJson) {
        Logger.getLogger().d("FirebaseCrashlytics", "Writing settings to cache file...");
        if (settingsJson != null) {
            FileWriter writer = null;
            try {
                settingsJson.put("expires_at", expiresAtMillis);
                writer = new FileWriter(this.getSettingsFile());
                writer.write(settingsJson.toString());
                writer.flush();
            }
            catch (Exception e) {
                try {
                    Logger.getLogger().e("FirebaseCrashlytics", "Failed to cache settings", e);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeOrLog(writer, "Failed to close settings writer.");
                    throw throwable;
                }
                CommonUtils.closeOrLog(writer, "Failed to close settings writer.");
            }
            CommonUtils.closeOrLog(writer, "Failed to close settings writer.");
        }
    }
}

