/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.text.TextUtils;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.ndk.NativeApi;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class JniNativeApi
implements NativeApi {
    private static final boolean LIB_CRASHLYTICS_LOADED;
    private static final FilenameFilter APK_FILTER;
    private final Context context;

    public JniNativeApi(Context context) {
        this.context = context;
    }

    public static boolean isAtLeastLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private static String getVersionCodeAsString(PackageInfo pi) {
        return Build.VERSION.SDK_INT >= 28 ? Long.toString(pi.getLongVersionCode()) : Integer.toString(pi.versionCode);
    }

    @TargetApi(value=21)
    public static void addSplitSourceDirs(List<String> zipPaths, PackageInfo packageInfo) {
        File verifiedSplitsDir;
        ApplicationInfo applicationInfo = packageInfo.applicationInfo;
        if (applicationInfo.splitSourceDirs != null) {
            Collections.addAll(zipPaths, applicationInfo.splitSourceDirs);
        }
        if (!(verifiedSplitsDir = new File(applicationInfo.dataDir, String.format("files/splitcompat/%s/verified-splits", JniNativeApi.getVersionCodeAsString(packageInfo)))).exists()) {
            Logger.getLogger().d("No dynamic features found at " + verifiedSplitsDir.getAbsolutePath());
            return;
        }
        File[] allApks = verifiedSplitsDir.listFiles(APK_FILTER);
        if (allApks == null) {
            allApks = new File[]{};
        }
        Logger.getLogger().d("Found " + allApks.length + " APKs in " + verifiedSplitsDir.getAbsolutePath());
        for (File apk : allApks) {
            Logger.getLogger().d("Adding " + apk.getName() + " to classpath.");
            zipPaths.add(apk.getAbsolutePath());
        }
    }

    private static int getPackageInfoFlags() {
        return Build.VERSION.SDK_INT >= 24 ? 9216 : 1024;
    }

    public String[] makePackagePaths(String arch) {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), JniNativeApi.getPackageInfoFlags());
            ArrayList<String> zipPaths = new ArrayList<String>(10);
            zipPaths.add(pi.applicationInfo.sourceDir);
            if (JniNativeApi.isAtLeastLollipop()) {
                JniNativeApi.addSplitSourceDirs(zipPaths, pi);
            }
            if (pi.applicationInfo.sharedLibraryFiles != null) {
                Collections.addAll(zipPaths, pi.applicationInfo.sharedLibraryFiles);
            }
            ArrayList<String> libPaths = new ArrayList<String>(10);
            File parent = new File(pi.applicationInfo.nativeLibraryDir).getParentFile();
            if (parent != null) {
                libPaths.add(new File(parent, arch).getPath());
                if (arch.startsWith("arm64")) {
                    libPaths.add(new File(parent, "arm64").getPath());
                } else if (arch.startsWith("arm")) {
                    libPaths.add(new File(parent, "arm").getPath());
                }
            }
            for (String zip : zipPaths) {
                if (!zip.endsWith(".apk")) continue;
                libPaths.add(zip + "!/lib/" + arch);
            }
            libPaths.add(System.getProperty("java.library.path"));
            libPaths.add(pi.applicationInfo.nativeLibraryDir);
            return new String[]{TextUtils.join((CharSequence)File.pathSeparator, zipPaths), TextUtils.join((CharSequence)File.pathSeparator, libPaths)};
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.getLogger().e("Unable to compose package paths", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean initialize(String dataPath, AssetManager assetManager) {
        String[] paths = this.makePackagePaths(Build.CPU_ABI);
        if (paths.length < 2) {
            return false;
        }
        String classpath = paths[0];
        String libspath = paths[1];
        return LIB_CRASHLYTICS_LOADED && this.nativeInit(new String[]{classpath, libspath, dataPath}, assetManager);
    }

    private native boolean nativeInit(String[] var1, Object var2);

    static {
        APK_FILTER = (file, name) -> name.toLowerCase().endsWith(".apk");
        boolean loadSuccessful = false;
        try {
            System.loadLibrary("crashlytics");
            loadSuccessful = true;
        }
        catch (UnsatisfiedLinkError e) {
            Logger.getLogger().e("libcrashlytics could not be loaded. This APK may not have been compiled for this device's architecture. NDK crashes will not be reported to Crashlytics:\n" + e.getLocalizedMessage());
        }
        LIB_CRASHLYTICS_LOADED = loadSuccessful;
    }
}

