/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.elf;

import com.google.common.base.Optional;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSectionHeader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSectionHeaders;

public class DebugElfSectionHeaders {
    public final ElfSectionHeader debugInfo;
    public final ElfSectionHeader debugAbbrev;
    public final ElfSectionHeader debugStr;
    public final ElfSectionHeader debugRanges;
    public final ElfSectionHeader debugLine;

    public static Optional<DebugElfSectionHeaders> from(ElfSectionHeaders elfHeaders) {
        Optional<ElfSectionHeader> debugInfo = elfHeaders.getHeaderByName(".debug_info");
        Optional<ElfSectionHeader> debugAbbrev = elfHeaders.getHeaderByName(".debug_abbrev");
        Optional<ElfSectionHeader> debugStr = elfHeaders.getHeaderByName(".debug_str");
        Optional<ElfSectionHeader> debugRanges = elfHeaders.getHeaderByName(".debug_ranges");
        Optional<ElfSectionHeader> debugLine = elfHeaders.getHeaderByName(".debug_line");
        if (!(debugInfo.isPresent() && debugAbbrev.isPresent() && debugStr.isPresent() && debugLine.isPresent())) {
            return Optional.absent();
        }
        return Optional.of((Object)new DebugElfSectionHeaders((ElfSectionHeader)debugInfo.get(), (ElfSectionHeader)debugAbbrev.get(), (ElfSectionHeader)debugStr.get(), (ElfSectionHeader)debugLine.get(), (ElfSectionHeader)debugRanges.orNull()));
    }

    DebugElfSectionHeaders(ElfSectionHeader debugInfo, ElfSectionHeader debugAbbrev, ElfSectionHeader debugStr, ElfSectionHeader debugLine, ElfSectionHeader debugRanges) {
        this.debugInfo = debugInfo;
        this.debugAbbrev = debugAbbrev;
        this.debugStr = debugStr;
        this.debugRanges = debugRanges;
        this.debugLine = debugLine;
    }
}

