/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf;

import com.google.common.base.Charsets;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineEntry;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineHeader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineOpcode;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineRegisters;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DwarfException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.ExtendedOpcodeDefineFile;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.ExtendedOpcodeEndSequence;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.ExtendedOpcodeSetAddress;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.ExtendedOpcodeSetDiscriminator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.SpecialOpcode;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeAdvanceLine;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeAdvancePC;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeConstAddPC;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeCopy;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeFixedAdvancePC;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeNegateStatement;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeSetBasicBlock;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeSetColumn;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeSetEpilogueBegin;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeSetFile;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeSetIsa;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.StandardOpcodeSetPrologueEnd;
import com.google.firebase.crashlytics.buildtools.utils.io.ByteReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class DebugLineStateMachine {
    private static final int EXTENDED_OPCODE = 0;
    private static final DebugLineOpcode[] STANDARD_OPCODES = new DebugLineOpcode[]{null, new StandardOpcodeCopy(), new StandardOpcodeAdvancePC(), new StandardOpcodeAdvanceLine(), new StandardOpcodeSetFile(), new StandardOpcodeSetColumn(), new StandardOpcodeNegateStatement(), new StandardOpcodeSetBasicBlock(), new StandardOpcodeConstAddPC(), new StandardOpcodeFixedAdvancePC(), new StandardOpcodeSetPrologueEnd(), new StandardOpcodeSetEpilogueBegin(), new StandardOpcodeSetIsa()};
    private static final DebugLineOpcode[] EXTENDED_OPCODES = new DebugLineOpcode[]{null, new ExtendedOpcodeEndSequence(), new ExtendedOpcodeSetAddress(), new ExtendedOpcodeDefineFile(), new ExtendedOpcodeSetDiscriminator()};
    private boolean _dwarf64 = false;

    public List<DebugLineEntry> runFromCurrentOffset(ByteReader reader, int pointerSize) throws IOException, DwarfException {
        long unitLength = this.readInitialLength(reader);
        long endOffset = reader.getCurrentOffset() + unitLength;
        DebugLineContext context = this.configureContext(reader, unitLength, pointerSize);
        return DebugLineStateMachine.readCompilationUnit(context, reader, endOffset);
    }

    public List<DebugLineEntry> runForIndex(ByteReader reader, int index, long endOffset, int pointerSize) throws IOException, DwarfException {
        for (int i2 = 0; i2 < index; ++i2) {
            if (reader.getCurrentOffset() >= endOffset) {
                throw new DwarfException("Unable to set appropriate line number section offset");
            }
            reader.seek(this.readInitialLength(reader) + reader.getCurrentOffset());
        }
        return this.runFromCurrentOffset(reader, pointerSize);
    }

    private DebugLineContext configureContext(ByteReader dataReader, long unitLength, int pointerSize) throws IOException {
        int version = dataReader.readInt(2);
        long headerLength = dataReader.readLong(this._dwarf64 ? 8 : 4);
        byte minInstructionLength = dataReader.readByte();
        byte maxOperationsPerInstruction = version >= 4 ? dataReader.readByte() : (byte)1;
        boolean defaultIsStatement = dataReader.readByte() != 0;
        byte lineBase = dataReader.readByte();
        byte lineRange = dataReader.readByte();
        byte by = dataReader.readByte();
        byte[] standardOpcodeLengths = new byte[by];
        for (int i2 = 1; i2 < by; ++i2) {
            standardOpcodeLengths[i2] = dataReader.readByte();
        }
        DebugLineHeader header = new DebugLineHeader(unitLength, version, headerLength, minInstructionLength, maxOperationsPerInstruction, defaultIsStatement, lineBase, lineRange, by, standardOpcodeLengths);
        DebugLineRegisters registers = new DebugLineRegisters(defaultIsStatement);
        DebugLineContext context = new DebugLineContext(header, registers, pointerSize);
        String directory = dataReader.readNullTerminatedString(Charsets.UTF_8);
        while (directory.length() > 0) {
            context.defineDirectory(directory);
            directory = dataReader.readNullTerminatedString(Charsets.UTF_8);
        }
        String fileName = dataReader.readNullTerminatedString(Charsets.UTF_8);
        while (fileName.length() > 0) {
            int dirIndex = dataReader.readULEB128();
            int modTime = dataReader.readULEB128();
            int length = dataReader.readULEB128();
            context.defineFile(fileName, dirIndex, modTime, length);
            fileName = dataReader.readNullTerminatedString(Charsets.UTF_8);
        }
        return context;
    }

    private static List<DebugLineEntry> readCompilationUnit(DebugLineContext context, ByteReader dataReader, long endOffset) throws IOException, DwarfException {
        LinkedList<DebugLineEntry> data = new LinkedList<DebugLineEntry>();
        while (dataReader.getCurrentOffset() < endOffset) {
            boolean addRow = DebugLineStateMachine.processOpcode(context, dataReader);
            if (addRow) {
                long address = context.reg.address;
                String file = context.getFileInfo((int)context.reg.file).name;
                long lineNumber = context.reg.line;
                data.add(new DebugLineEntry(address, file, lineNumber));
            }
            if (!context.reg.isEndSequence) continue;
            context.reg.reset();
        }
        return data;
    }

    private static boolean processOpcode(DebugLineContext context, ByteReader dataReader) throws IOException, DwarfException {
        DebugLineOpcode debugLineOpcode;
        int opcode = dataReader.readInt(1);
        if (opcode < 0) {
            throw new DwarfException("Could not process opcode " + opcode);
        }
        if (opcode >= context.header.opcodeBase) {
            debugLineOpcode = new SpecialOpcode(opcode);
        } else if (opcode == 0) {
            int length = dataReader.readULEB128();
            int exOpcode = dataReader.readInt(1);
            debugLineOpcode = DebugLineStateMachine.getOpcode(exOpcode, EXTENDED_OPCODES);
        } else {
            debugLineOpcode = DebugLineStateMachine.getOpcode(opcode, STANDARD_OPCODES);
        }
        return debugLineOpcode.process(context, dataReader);
    }

    private long readInitialLength(ByteReader dataReader) throws IOException {
        long initialLength = dataReader.readLong(4);
        if (initialLength == -1L) {
            this._dwarf64 = true;
            initialLength = dataReader.readLong(8);
        }
        return initialLength;
    }

    private static DebugLineOpcode getOpcode(int opcode, DebugLineOpcode[] opcodes) throws DwarfException {
        if (opcode < 0 || opcode >= opcodes.length) {
            throw new DwarfException("Unknown opcode: " + opcode);
        }
        return opcodes[opcode];
    }
}

