/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.CodeMappingException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSym;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymFactory;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymFileWriter;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.ElfCSymFactory;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.StandardCSymFileWriter;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;

public class NdkCSymGenerator
implements NativeSymbolGenerator {
    public static final String CSYM_SUFFIX = ".cSYM";

    @Override
    public File generateSymbols(File nativeLib, File outputDir) throws IOException, CodeMappingException {
        ElfCSymFactory cSymFactory = new ElfCSymFactory(true);
        StandardCSymFileWriter cSymFileWriter = new StandardCSymFileWriter();
        return this.generateSymbolFileFromFile(nativeLib, outputDir, cSymFactory, cSymFileWriter);
    }

    File generateSymbolFileFromFile(File nativeLib, File outputDir, CSymFactory cSymFactory, CSymFileWriter cSymFileWriter) throws IOException, CodeMappingException {
        CSym cSym;
        Buildtools.logD("Generating native symbol file from: " + nativeLib);
        if (nativeLib == null || !nativeLib.isFile()) {
            throw new CodeMappingException("Specified path is not a file: " + nativeLib);
        }
        FileUtils.verifyDirectory(outputDir);
        try {
            cSym = cSymFactory.createCSymFromFile(nativeLib);
        }
        catch (CSymException e) {
            throw new CodeMappingException(e);
        }
        if (cSym.getUUID() == null || cSym.getUUID().equals("")) {
            Buildtools.logD("Crashlytics could not generate a UUID for " + nativeLib + ", skipping.");
        }
        if (cSym.getSymbols().isEmpty()) {
            Buildtools.logD("Crashlytics found no symbols for " + nativeLib + ", skipping.");
            return null;
        }
        String cSymFilename = NativeSymbolGenerator.createSymbolFileBasename(nativeLib.getName(), cSym.getArchitecture(), cSym.getUUID()) + CSYM_SUFFIX;
        File outputFile = new File(outputDir, cSymFilename);
        cSymFileWriter.writeCSymFile(cSym, outputFile);
        return outputFile;
    }
}

