/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.firebase.crashlytics.buildtools.api.FirebaseSymbolFileService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class CsymSymbolFileService
extends FirebaseSymbolFileService {
    private static final String CSYM_UPLOAD_REQUEST_FORMAT = "%s/v1/project/-/app/%s/upload/native/%s";

    public CsymSymbolFileService() {
        super(CSYM_UPLOAD_REQUEST_FORMAT);
    }

    @Override
    protected String extractUuid(File cSymFile) throws IOException {
        String cSymHeader = CsymSymbolFileService.readCSymHeader(cSymFile);
        String[] headerTokens = cSymHeader.split("\t");
        if (headerTokens.length != 8 || !headerTokens[0].equals("code_mapping")) {
            throw new IOException("Invalid cSYM header for " + cSymFile.getAbsolutePath());
        }
        return headerTokens[3];
    }

    private static String readCSymHeader(File cSymFile) throws IOException {
        String cSymHeader;
        try (BufferedReader reader = new BufferedReader(new FileReader(cSymFile));){
            cSymHeader = reader.readLine();
        }
        if (cSymHeader == null || cSymHeader.length() == 0) {
            throw new IOException("Could not read cSYM header for " + cSymFile.getPath());
        }
        return cSymHeader;
    }
}

