/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.mappingfiles;

import com.google.firebase.crashlytics.buildtools.mappingfiles.XmlResourceUtils;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MappingFileIdWriter {
    public static final String MAPPING_FILE_ID_RESOURCE_FILENAME = "com_google_firebase_crashlytics_mappingfileid.xml";
    private final File resourceFile;

    public MappingFileIdWriter(File resourceFile) {
        this.resourceFile = resourceFile;
    }

    public void writeMappingFileId(String id) throws IOException {
        try {
            InputStream is = XmlResourceUtils.createResourceFileStream(id);
            if (this.resourceFile.getParentFile() != null) {
                FileUtils.verifyDirectory(this.resourceFile.getParentFile());
            }
            FileUtils.writeInputStreamToFile(is, this.resourceFile);
        }
        catch (Exception e) {
            throw new IOException("Crashlytics could not create: " + this.resourceFile, e);
        }
    }
}

