/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle;

import com.google.firebase.crashlytics.buildtools.AppBuildInfo;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.Obfuscator;
import com.google.firebase.crashlytics.buildtools.api.SymbolFileService;
import com.google.firebase.crashlytics.buildtools.log.CrashlyticsLogger;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\nH\u0002J\u0006\u0010\u001a\u001a\u00020\u0004J%\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001dJ\u0016\u0010%\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0004J/\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010(\u001a\u00020\u00042\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040*\"\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010+J-\u0010,\u001a\u0004\u0018\u00010\u00162\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00102J%\u00103\u001a\u0004\u0018\u00010\u00162\u0006\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u000207\u00a2\u0006\u0002\u00108R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsBuildtools;", "", "()V", "BLANK_MAPPING_FILE_ID", "", "BUILDTOOLS_PROPERTY", "DEBUG_LOG_REDIRECT_PROPERTY", "FAKE_ID_PROPERTY", "FAKE_OUTPUT_PROPERTY", "buildtools", "Lcom/google/firebase/crashlytics/buildtools/Buildtools;", "getBuildtools", "()Lcom/google/firebase/crashlytics/buildtools/Buildtools;", "buildtools$delegate", "Lkotlin/Lazy;", "fakeId", "generateFakeOutput", "", "isFake", "logger", "Lcom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsBuildtools$CrashlyticsGradleLogger;", "configure", "", "project", "Lorg/gradle/api/Project;", "configureBuildtools", "generateMappingFileId", "generateNativeSymbolFiles", "path", "Ljava/io/File;", "symbolFileOutputDir", "symbolGenerator", "Lcom/google/firebase/crashlytics/buildtools/ndk/NativeSymbolGenerator;", "(Ljava/io/File;Ljava/io/File;Lcom/google/firebase/crashlytics/buildtools/ndk/NativeSymbolGenerator;)Lkotlin/Unit;", "injectBuildIdsIntoResource", "mergedNativeLibsPath", "resourceFile", "injectMappingFileIdIntoResource", "mappingFileId", "logPretendCall", "functionName", "params", "", "(Ljava/lang/String;[Ljava/lang/String;)Lkotlin/Unit;", "uploadMappingFile", "mappingFile", "appBuildInfo", "Lcom/google/firebase/crashlytics/buildtools/AppBuildInfo;", "obfuscator", "Lcom/google/firebase/crashlytics/buildtools/Obfuscator;", "(Ljava/io/File;Ljava/lang/String;Lcom/google/firebase/crashlytics/buildtools/AppBuildInfo;Lcom/google/firebase/crashlytics/buildtools/Obfuscator;)Lkotlin/Unit;", "uploadNativeSymbolFiles", "symbolFileDir", "appId", "symbolFileService", "Lcom/google/firebase/crashlytics/buildtools/api/SymbolFileService;", "(Ljava/io/File;Ljava/lang/String;Lcom/google/firebase/crashlytics/buildtools/api/SymbolFileService;)Lkotlin/Unit;", "CrashlyticsGradleLogger", "crashlytics-gradle"})
@SourceDebugExtension(value={"SMAP\nCrashlyticsBuildtools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashlyticsBuildtools.kt\ncom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsBuildtools\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1#2:212\n766#3:213\n857#3,2:214\n*S KotlinDebug\n*F\n+ 1 CrashlyticsBuildtools.kt\ncom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsBuildtools\n*L\n163#1:213\n163#1:214,2\n*E\n"})
public final class CrashlyticsBuildtools {
    @NotNull
    public static final CrashlyticsBuildtools INSTANCE = new CrashlyticsBuildtools();
    @NotNull
    public static final String BLANK_MAPPING_FILE_ID = "00000000000000000000000000000000";
    @NotNull
    private static final String BUILDTOOLS_PROPERTY = "com.google.firebase.crashlytics.buildtools";
    @NotNull
    private static final String DEBUG_LOG_REDIRECT_PROPERTY = "com.google.firebase.crashlytics.logDebug";
    @NotNull
    private static final String FAKE_OUTPUT_PROPERTY = "com.google.firebase.crashlytics.fakeOutput";
    @NotNull
    private static final String FAKE_ID_PROPERTY = "com.google.firebase.crashlytics.fakeId";
    @NotNull
    private static final Lazy buildtools$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Buildtools>((Object)INSTANCE){

        @NotNull
        public final Buildtools invoke() {
            return CrashlyticsBuildtools.access$configureBuildtools((CrashlyticsBuildtools)this.receiver);
        }
    }));
    private static boolean isFake;
    private static boolean generateFakeOutput;
    @Nullable
    private static String fakeId;
    @Nullable
    private static CrashlyticsGradleLogger logger;

    private CrashlyticsBuildtools() {
    }

    private final Buildtools getBuildtools() {
        Lazy lazy = buildtools$delegate;
        return (Buildtools)lazy.getValue();
    }

    public final void configure(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        isFake = Intrinsics.areEqual((Object)project.findProperty(BUILDTOOLS_PROPERTY), (Object)"pretend");
        generateFakeOutput = Intrinsics.areEqual((Object)project.findProperty(FAKE_OUTPUT_PROPERTY), (Object)"generate");
        Object object = project.findProperty(FAKE_ID_PROPERTY);
        fakeId = object instanceof String ? (String)object : null;
        Logger logger = project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        Object object2 = project.findProperty(DEBUG_LOG_REDIRECT_PROPERTY);
        String string = object2 instanceof String ? (String)object2 : null;
        if (string == null) {
            string = "DEBUG";
        }
        CrashlyticsBuildtools.logger = new CrashlyticsGradleLogger(logger, CrashlyticsLogger.Level.valueOf(string));
    }

    @Nullable
    public final Unit generateNativeSymbolFiles(@NotNull File path, @NotNull File symbolFileOutputDir, @NotNull NativeSymbolGenerator symbolGenerator) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)symbolFileOutputDir, (String)"symbolFileOutputDir");
        Intrinsics.checkNotNullParameter((Object)symbolGenerator, (String)"symbolGenerator");
        if (isFake) {
            if (generateFakeOutput) {
                symbolFileOutputDir.mkdirs();
                FilesKt.writeText$default((File)new File(symbolFileOutputDir, "fake.so"), (String)"Matt says hi!", null, (int)2, null);
            }
            String[] stringArray = new String[]{path.getName(), symbolFileOutputDir.getName(), Reflection.getOrCreateKotlinClass(symbolGenerator.getClass()).getSimpleName()};
            unit = this.logPretendCall("generateNativeSymbolFiles", stringArray);
        } else {
            this.getBuildtools().generateNativeSymbolFiles(path, symbolFileOutputDir, symbolGenerator);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    public final boolean injectBuildIdsIntoResource(@NotNull File mergedNativeLibsPath, @NotNull File resourceFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)mergedNativeLibsPath, (String)"mergedNativeLibsPath");
        Intrinsics.checkNotNullParameter((Object)resourceFile, (String)"resourceFile");
        if (isFake) {
            String[] stringArray = new String[]{mergedNativeLibsPath.getName(), resourceFile.getName()};
            this.logPretendCall("injectBuildIdsIntoResource", stringArray);
            bl = true;
        } else {
            bl = this.getBuildtools().injectBuildIdsIntoResource(mergedNativeLibsPath, resourceFile);
        }
        return bl;
    }

    public final boolean injectMappingFileIdIntoResource(@NotNull File resourceFile, @NotNull String mappingFileId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resourceFile, (String)"resourceFile");
        Intrinsics.checkNotNullParameter((Object)mappingFileId, (String)"mappingFileId");
        if (isFake) {
            String[] stringArray = new String[]{resourceFile.getName(), mappingFileId};
            this.logPretendCall("injectMappingFileIdIntoResource", stringArray);
            bl = true;
        } else {
            bl = this.getBuildtools().injectMappingFileIdIntoResource(resourceFile, mappingFileId);
        }
        return bl;
    }

    @Nullable
    public final Unit uploadMappingFile(@NotNull File mappingFile, @NotNull String mappingFileId, @NotNull AppBuildInfo appBuildInfo, @NotNull Obfuscator obfuscator) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)mappingFile, (String)"mappingFile");
        Intrinsics.checkNotNullParameter((Object)mappingFileId, (String)"mappingFileId");
        Intrinsics.checkNotNullParameter((Object)appBuildInfo, (String)"appBuildInfo");
        Intrinsics.checkNotNullParameter((Object)obfuscator, (String)"obfuscator");
        if (isFake) {
            String[] stringArray = new String[]{mappingFile.getName(), mappingFileId, appBuildInfo.getPackageName() + " " + appBuildInfo.getGoogleAppId() + " " + appBuildInfo.getBuildDir().getName(), obfuscator.getVendor().name() + " " + obfuscator.getVersion()};
            unit = this.logPretendCall("uploadMappingFile", stringArray);
        } else {
            this.getBuildtools().uploadMappingFile(mappingFile, mappingFileId, appBuildInfo, obfuscator);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    @Nullable
    public final Unit uploadNativeSymbolFiles(@NotNull File symbolFileDir, @NotNull String appId, @NotNull SymbolFileService symbolFileService) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)symbolFileDir, (String)"symbolFileDir");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)symbolFileService, (String)"symbolFileService");
        if (isFake) {
            String[] stringArray = new String[]{symbolFileDir.getName(), appId, Reflection.getOrCreateKotlinClass(symbolFileService.getClass()).getSimpleName()};
            unit = this.logPretendCall("uploadNativeSymbolFiles", stringArray);
        } else {
            this.getBuildtools().uploadNativeSymbolFiles(symbolFileDir, appId, symbolFileService);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    @NotNull
    public final String generateMappingFileId() {
        String string;
        if (isFake) {
            string = fakeId;
            if (string == null) {
                string = "test1234";
            }
        } else {
            String string2 = Buildtools.generateMappingFileId();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      Buildtools.generateMappingFileId()\n    }");
        }
        return string;
    }

    private final Buildtools configureBuildtools() {
        Buildtools buildtools2 = Buildtools.getInstance();
        CrashlyticsGradleLogger crashlyticsGradleLogger = logger;
        if (crashlyticsGradleLogger != null) {
            CrashlyticsLogger p0 = crashlyticsGradleLogger;
            boolean bl = false;
            Buildtools.setLogger(p0);
        }
        Package package_ = this.getClass().getPackage();
        Package package_2 = this.getClass().getPackage();
        buildtools2.setBuildtoolsClientInfo(package_ != null ? package_.getImplementationTitle() : null, package_2 != null ? package_2.getImplementationVersion() : null);
        Intrinsics.checkNotNullExpressionValue((Object)buildtools2, (String)"buildtools");
        return buildtools2;
    }

    /*
     * WARNING - void declaration
     */
    private final Unit logPretendCall(String functionName, String ... params) {
        Unit unit;
        CrashlyticsGradleLogger crashlyticsGradleLogger = logger;
        if (crashlyticsGradleLogger != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = ArraysKt.filterNotNull((Object[])params);
            String string = functionName;
            CrashlyticsGradleLogger crashlyticsGradleLogger2 = crashlyticsGradleLogger;
            boolean $i$f$filter = false;
            void var5_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String p0 = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)p0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            crashlyticsGradleLogger2.logQ(string + " - " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final /* synthetic */ Buildtools access$configureBuildtools(CrashlyticsBuildtools $this) {
        return $this.configureBuildtools();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsBuildtools$CrashlyticsGradleLogger;", "Lcom/google/firebase/crashlytics/buildtools/log/CrashlyticsLogger;", "projectLogger", "Lorg/gradle/api/logging/Logger;", "debugRedirect", "Lcom/google/firebase/crashlytics/buildtools/log/CrashlyticsLogger$Level;", "(Lorg/gradle/api/logging/Logger;Lcom/google/firebase/crashlytics/buildtools/log/CrashlyticsLogger$Level;)V", "level", "logD", "", "msg", "", "logE", "t", "", "logI", "logQ", "logV", "logW", "setLevel", "crashlytics-gradle"})
    private static final class CrashlyticsGradleLogger
    implements CrashlyticsLogger {
        @NotNull
        private final Logger projectLogger;
        @NotNull
        private final CrashlyticsLogger.Level debugRedirect;
        @NotNull
        private CrashlyticsLogger.Level level;

        public CrashlyticsGradleLogger(@NotNull Logger projectLogger, @NotNull CrashlyticsLogger.Level debugRedirect) {
            Intrinsics.checkNotNullParameter((Object)projectLogger, (String)"projectLogger");
            Intrinsics.checkNotNullParameter((Object)((Object)debugRedirect), (String)"debugRedirect");
            this.projectLogger = projectLogger;
            this.debugRedirect = debugRedirect;
            this.level = CrashlyticsLogger.Level.DEBUG;
        }

        public /* synthetic */ CrashlyticsGradleLogger(Logger logger, CrashlyticsLogger.Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                level = CrashlyticsLogger.Level.DEBUG;
            }
            this(logger, level);
        }

        @Override
        public void setLevel(@NotNull CrashlyticsLogger.Level level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            this.level = level;
        }

        @Override
        public void logV(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            if (this.level.logsFor(CrashlyticsLogger.Level.VERBOSE)) {
                this.projectLogger.debug(msg);
            }
        }

        @Override
        public void logD(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            switch (WhenMappings.$EnumSwitchMapping$0[this.debugRedirect.ordinal()]) {
                case 1: {
                    this.projectLogger.error(msg);
                    break;
                }
                case 2: {
                    this.projectLogger.warn(msg);
                    break;
                }
                case 3: {
                    this.projectLogger.info(msg);
                    break;
                }
                default: {
                    this.projectLogger.debug(msg);
                }
            }
        }

        @Override
        public void logI(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.projectLogger.info(msg);
        }

        @Override
        public void logW(@NotNull String msg, @Nullable Throwable t) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.projectLogger.warn(msg, t);
        }

        public final void logQ(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.projectLogger.quiet(msg);
        }

        @Override
        public void logE(@NotNull String msg, @Nullable Throwable t) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.projectLogger.error(msg, t);
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CrashlyticsLogger.Level.values().length];
                try {
                    nArray[CrashlyticsLogger.Level.ERROR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CrashlyticsLogger.Level.WARNING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CrashlyticsLogger.Level.INFO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

