/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class BreakpadRecords {
    private final String os;
    private final String architecture;
    private final String moduleId;
    private final String name;
    private final String codeId;

    public static BreakpadRecords createFromBreakpadFile(File breakpadFile) throws IOException {
        String codeId;
        BufferedReader reader = new BufferedReader(new FileReader(breakpadFile));
        String line = reader.readLine();
        String[] splitModuleLine = line.split(" ");
        if (splitModuleLine.length < 5 || !splitModuleLine[0].equals("MODULE")) {
            throw new IOException("Could not find valid module record for Breakpad file: " + breakpadFile.getAbsolutePath() + " Clean your build directory and try again. Contact Firebase support if the problem persists.");
        }
        String[] splitInfoLine = new String[]{};
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("INFO")) continue;
            splitInfoLine = line.split(" ");
            break;
        }
        reader.close();
        if (splitInfoLine.length >= 3) {
            codeId = splitInfoLine[2];
        } else {
            codeId = null;
            Buildtools.logW("Invalid or missing INFO line, no CODE_ID found for " + breakpadFile.getAbsolutePath());
        }
        return new BreakpadRecords(splitModuleLine[1], splitModuleLine[2], splitModuleLine[3].toLowerCase(), splitModuleLine[4], codeId.toLowerCase());
    }

    public BreakpadRecords(String os, String architecture, String moduleId, String name, String codeId) {
        this.os = os;
        this.architecture = architecture;
        this.moduleId = moduleId;
        this.name = name;
        this.codeId = codeId;
    }

    public String getOs() {
        return this.os;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getName() {
        return this.name;
    }

    public String getCodeId() {
        return this.codeId;
    }
}

