/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.buildids;

import com.google.firebase.crashlytics.buildtools.buildids.BuildIdInfo;
import com.google.firebase.crashlytics.buildtools.buildids.XmlResourceUtils;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class BuildIdsWriter {
    public static final String BUILD_IDS_RESOURCE_FILENAME = "com_google_firebase_crashlytics_build_ids.xml";
    private final File resourceFile;

    public BuildIdsWriter(File resourceFile) {
        this.resourceFile = resourceFile;
    }

    public void writeBuildIds(List<BuildIdInfo> buildIdInfoList) throws IOException {
        try {
            InputStream is = XmlResourceUtils.createResourceFileStream(buildIdInfoList);
            if (this.resourceFile.getParentFile() != null) {
                FileUtils.verifyDirectory(this.resourceFile.getParentFile());
            }
            FileUtils.writeInputStreamToFile(is, this.resourceFile);
        }
        catch (Exception e) {
            throw new IOException("Crashlytics could not create: " + this.resourceFile, e);
        }
    }
}

