/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf;

import java.util.HashMap;
import java.util.Map;

public enum DWAttribute {
    SIBLING(1, "sibling"),
    LOCATION(2, "location"),
    NAME(3, "name"),
    ORDERING(9, "ordering"),
    SUBSCR_DATA(10, "subscr_data"),
    BYTE_SIZE(11, "byte_size"),
    BIT_OFFSET(12, "bit_offset"),
    BIT_SIZE(13, "bit_size"),
    ELEMENT_LIST(15, "element_list"),
    STMT_LIST(16, "stmt_list"),
    LOW_PC(17, "low_pc"),
    HIGH_PC(18, "high_pc"),
    LANGUAGE(19, "language"),
    MEMBER(20, "member"),
    DISCR(21, "discr"),
    DISCR_VALUE(22, "discr_value"),
    VISIBILITY(23, "visibility"),
    IMPORT(24, "import"),
    STRING_LENGTH(25, "string_length"),
    COMMON_REFERENCE(26, "common_reference"),
    COMP_DIR(27, "comp_dir"),
    CONST_VALUE(28, "const_value"),
    CONTAINING_TYPE(29, "containing_type"),
    DEFAULT_VALUE(30, "default_value"),
    INLINE(32, "inline"),
    IS_OPTIONAL(33, "is_optional"),
    LOWER_BOUND(34, "lower_bound"),
    PRODUCER(37, "producer"),
    PROTOTYPED(39, "prototyped"),
    RETURN_ADDR(42, "return_addr"),
    START_SCOPE(44, "start_scope"),
    BIT_STRIDE(46, "bit_stride"),
    UPPER_BOUND(47, "upper_bound"),
    ABSTRACT_ORIGIN(49, "abstract_origin"),
    ACCESSIBILITY(50, "accessibility"),
    ADDRESS_CLASS(51, "address_class"),
    ARTIFICIAL(52, "artificial"),
    BASE_TYPES(53, "base_types"),
    CALLING_CONVENTION(54, "calling_convention"),
    COUNT(55, "count"),
    DATA_MEMBER_LOCATION(56, "data_member_location"),
    DECL_COLUMN(57, "decl_column"),
    DECL_FILE(58, "decl_file"),
    DECL_LINE(59, "decl_line"),
    DECLARATION(60, "declaration"),
    DISCR_LIST(61, "discr_list"),
    ENCODING(62, "encoding"),
    EXTERNAL(63, "external"),
    FRAME_BASE(64, "frame_base"),
    FRIEND(65, "friend"),
    IDENTIFIER_CASE(66, "identifier_case"),
    MACRO_INFO(67, "macro_info"),
    NAMELIST_ITEM(68, "namelist_item"),
    PRIORITY(69, "priority"),
    SEGMENT(70, "segment"),
    SPECIFICATION(71, "specification"),
    STATIC_LINK(72, "static_link"),
    TYPE(73, "type"),
    USE_LOCATION(74, "use_location"),
    VARIABLE_PARAMETER(75, "variable_parameter"),
    VIRTUALITY(76, "virtuality"),
    VTABLE_ELEM_LOCATION(77, "vtable_elem_location"),
    ALLOCATED(78, "allocated"),
    ASSOCIATED(79, "associated"),
    DATA_LOCATION(80, "data_location"),
    BYTE_STRIDE(81, "byte_stride"),
    ENTRY_PC(82, "entry_pc"),
    USE_UTF8(83, "use_UTF8"),
    EXTENSION(84, "extension"),
    RANGES(85, "ranges"),
    TRAMPOLINE(86, "trampoline"),
    CALL_COLUMN(87, "call_column"),
    CALL_FILE(88, "call_file"),
    CALL_LINE(89, "call_line"),
    DESCRIPTION(90, "description"),
    BINARY_SCALE(91, "binary_scale"),
    DECIMAL_SCALE(92, "decimal_scale"),
    SMALL(93, "small"),
    DECIMAL_SIGN(94, "decimal_sign"),
    DIGIT_COUNT(95, "digit_count"),
    PICTURE_STRING(96, "picture_string"),
    MUTABLE(97, "mutable"),
    THREADS_SCALED(98, "threads_scaled"),
    EXPLICIT(99, "explicit"),
    OBJECT_POINTER(100, "object_pointer"),
    ENDIANITY(101, "endianity"),
    ELEMENTAL(102, "elemental"),
    PURE(103, "pure"),
    RECURSIVE(104, "recursive"),
    SIGNATURE(105, "signature"),
    MAIN_SUBPROGRAM(106, "main_subprogram"),
    DATA_BIT_OFFSET(107, "data_bit_offset"),
    CONST_EXPR(108, "const_expr"),
    ENUM_CLASS(109, "enum_class"),
    LINKAGE_NAME(110, "linkage_name"),
    STRING_LENGTH_BIT_SIZE(111, "string_length_bit_size"),
    STRING_LENGTH_BYTE_SIZE(112, "string_length_byte_size"),
    RANK(113, "rank"),
    STR_OFFSETS_BASE(114, "str_offsets_base"),
    ADDR_BASE(115, "addr_base"),
    RNGLISTS_BASE(116, "rnglists_base"),
    RESERVED(117, "Reserved"),
    DWO_NAME(118, "dwo_name"),
    REFERENCE(119, "reference"),
    RVALUE_REFERENCE(120, "rvalue_reference"),
    MACROS(121, "macros"),
    CALL_ALL_CALLS(122, "call_all_calls"),
    CALL_ALL_SOURCE_CALLS(123, "call_all_source_calls"),
    CALL_ALL_TAIL_CALLS(124, "call_all_tail_calls"),
    CALL_RETURN_PC(125, "call_return_pc"),
    CALL_VALUE(126, "call_value"),
    CALL_ORIGIN(127, "call_origin"),
    CALL_PARAMETER(128, "call_parameter"),
    CALL_PC(129, "call_pc"),
    CALL_TAIL_CALL(130, "call_tail_call"),
    CALL_TARGET(131, "call_target"),
    CALL_TARGET_CLOBBERED(132, "call_target_clobbered"),
    CALL_DATA_LOCATION(133, "call_data_location"),
    CALL_DATA_VALUE(134, "call_data_value"),
    NORETURN(135, "noreturn"),
    ALIGNMENT(136, "alignment"),
    EXPORT_SYMBOLS(137, "export_symbols"),
    DELETED(138, "deleted"),
    DEFAULTED(139, "defaulted"),
    LOCLISTS_BASE(140, "loclists_base"),
    LO_USER(8192, "lo_user"),
    MIPS_FDE(8193, "MIPS_fde"),
    MIPS_LOOP_BEGIN(8194, "MIPS_loop_begin"),
    MIPS_TAIL_LOOP_BEGIN(8195, "MIPS_tail_loop_begin"),
    MIPS_EPILOG_BEGIN(8196, "MIPS_epilog_begin"),
    MIPS_LOOP_UNROLL_FACTOR(8197, "MIPS_loop_unroll_factor"),
    MIPS_SOFTWARE_PIPELINE_DEPTH(8198, "MIPS_software_pipeline_depth"),
    MIPS_LINKAGE_NAME(8199, "MIPS_linkage_name"),
    MIPS_STRIDE(8200, "MIPS_stride"),
    MIPS_ABSTRACT_NAME(8201, "MIPS_abstract_name"),
    MIPS_CLONE_ORIGIN(8202, "MIPS_clone_origin"),
    MIPS_HAS_INLINES(8203, "MIPS_has_inlines"),
    MIPS_STRIDE_BYTE(8204, "MIPS_stride_byte"),
    MIPS_STRIDE_ELEM(8205, "MIPS_stride_elem"),
    MIPS_PTR_DOPETYPE(8206, "MIPS_ptr_dopetype"),
    MIPS_ALLOCATABLE_DOPETYPE(8207, "MIPS_allocatable_dopetype"),
    MIPS_ASSUMED_SHAPE_DOPETYPE(8208, "MIPS_assumed_shape_dopetype"),
    HP_ACTUALS_STMT_LIST(8208, "HP_actuals_stmt_list"),
    HP_PROC_PER_SECTION(8209, "HP_proc_per_section"),
    HP_RAW_DATA_PTR(8210, "HP_raw_data_ptr"),
    HP_PASS_BY_REFERENCE(8211, "HP_pass_by_reference"),
    HP_OPT_LEVEL(8212, "HP_opt_level"),
    HP_PROF_VERSION_ID(8213, "HP_prof_version_id"),
    HP_OPT_FLAGS(8214, "HP_opt_flags"),
    HP_COLD_REGION_LOW_PC(8215, "HP_cold_region_low_pc"),
    HP_COLD_REGION_HIGH_PC(8216, "HP_cold_region_high_pc"),
    HP_ALL_VARIABLES_MODIFIABLE(8217, "HP_all_variables_modifiable"),
    HP_LINKAGE_NAME(8218, "HP_linkage_name"),
    HP_PROF_FLAGS(8219, "HP_prof_flags"),
    HP_UNIT_NAME(8223, "HP_unit_name"),
    HP_UNIT_SIZE(8224, "HP_unit_size"),
    HP_WIDENED_BYTE_SIZE(8225, "HP_widened_byte_size"),
    HP_DEFINITION_POINTS(8226, "HP_definition_points"),
    HP_DEFAULT_LOCATION(8227, "HP_default_location"),
    HP_IS_RESULT_PARAM(8233, "HP_is_result_param"),
    INTEL_OTHER_ENDIAN(8230, "INTEL_other_endian"),
    SF_NAMES(8449, "sf_names"),
    SRC_INFO(8450, "src_info"),
    MAC_INFO(8451, "mac_info"),
    SRC_COORDS(8452, "src_coords"),
    BODY_BEGIN(8453, "body_begin"),
    BODY_END(8454, "body_end"),
    GNU_VECTOR(8455, "GNU_vector"),
    GNU_GUARDED_BY(8456, "GNU_guarded_by"),
    GNU_PT_GUARDED_BY(8457, "GNU_pt_guarded_by"),
    GNU_GUARDED(8458, "GNU_guarded"),
    GNU_PT_GUARDED(8459, "GNU_pt_guarded"),
    GNU_LOCKS_EXCLUDED(8460, "GNU_locks_excluded"),
    GNU_EXCLUSIVE_LOCKS_REQUIRED(8461, "GNU_exclusive_locks_required"),
    GNU_SHARED_LOCKS_REQUIRED(8462, "GNU_shared_locks_required"),
    GNU_ODR_SIGNATURE(8463, "GNU_odr_signature"),
    GNU_TEMPLATE_NAME(8464, "GNU_template_name"),
    GNU_CALL_SITE_VALUE(8465, "GNU_call_site_value"),
    GNU_CALL_SITE_DATA_VALUE(8466, "GNU_call_site_data_value"),
    GNU_CALL_SITE_TARGET(8467, "GNU_call_site_target"),
    GNU_CALL_SITE_TARGET_CLOBBERED(8468, "GNU_call_site_target_clobbered"),
    GNU_TAIL_CALL(8469, "GNU_tail_call"),
    GNU_ALL_TAIL_CALL_SITES(8470, "GNU_all_tail_call_sites"),
    GNU_ALL_CALL_SITES(8471, "GNU_all_call_sites"),
    GNU_ALL_SOURCE_CALL_SITES(8472, "GNU_all_source_call_sites"),
    GNU_MACROS(8473, "GNU_macros"),
    GNU_DELETED(8474, "GNU_deleted"),
    GNU_DWO_NAME(8496, "GNU_dwo_name"),
    GNU_DWO_ID(8497, "GNU_dwo_id"),
    GNU_RANGES_BASE(8498, "GNU_ranges_base"),
    GNU_ADDR_BASE(8499, "GNU_addr_base"),
    GNU_PUBNAMES(8500, "GNU_pubnames"),
    GNU_PUBTYPES(8501, "GNU_pubtypes"),
    GNU_DISCRIMINATOR(8502, "GNU_discriminator"),
    GNU_LOCVIEWS(8503, "GNU_locviews"),
    GNU_ENTRY_VIEW(8504, "GNU_entry_view"),
    VMS_RTNBEG_PD_ADDRESS(8705, "VMS_rtnbeg_pd_address"),
    USE_GNAT_DESCRIPTIVE_TYPE(8961, "use_GNAT_descriptive_type"),
    GNAT_DESCRIPTIVE_TYPE(8962, "GNAT_descriptive_type"),
    UPC_THREADS_SCALED(12816, "upc_threads_scaled"),
    PGI_LBASE(14848, "PGI_lbase"),
    PGI_SOFFSET(14849, "PGI_soffset"),
    PGI_LSTRIDE(14850, "PGI_lstride"),
    APPLE_OPTIMIZED(16353, "APPLE_optimized"),
    APPLE_FLAGS(16354, "APPLE_flags"),
    APPLE_ISA(16355, "APPLE_isa"),
    APPLE_BLOCK(16356, "APPLE_block"),
    APPLE_MAJOR_RUNTIME_VERS(16357, "APPLE_major_runtime_vers"),
    APPLE_RUNTIME_CLASS(16358, "APPLE_runtime_class"),
    APPLE_OMIT_FRAME_PTR(16359, "APPLE_omit_frame_ptr"),
    APPLE_PROPERTY_NAME(16360, "APPLE_property_name"),
    APPLE_PROPERTY_GETTER(16361, "APPLE_property_getter"),
    APPLE_PROPERTY_SETTER(16362, "APPLE_property_setter"),
    APPLE_PROPERTY_ATTRIBUTE(16363, "APPLE_property_attribute"),
    APPLE_OBJC_COMPLETE_TYPE(16364, "APPLE_objc_complete_type"),
    APPLE_PROPERTY(16365, "APPLE_property"),
    HI_USER(16383, "hi_user");

    private static final String PREFIX = "DW_AT_";
    private static final Map<Integer, DWAttribute> LOOKUP;
    private final int _value;
    private final String _name;
    private final String _fullName;

    private DWAttribute(int value, String name) {
        this._value = value;
        this._name = name;
        this._fullName = PREFIX + this._name;
    }

    public String toString() {
        return this._fullName;
    }

    public static DWAttribute fromValue(int value) {
        return LOOKUP.get(value);
    }

    static {
        LOOKUP = new HashMap<Integer, DWAttribute>();
        for (DWAttribute a : DWAttribute.values()) {
            LOOKUP.put(a._value, a);
        }
    }
}

