/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import com.google.common.base.Charsets;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugAbbrevEntry;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.AttributeProcessor;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.AttributesReader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.CompilationUnitContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.ReferenceBytesConverter;
import com.google.firebase.crashlytics.buildtools.utils.io.ByteReader;
import java.io.IOException;
import java.util.List;

public class DefaultAttributesReader<T>
implements AttributesReader<T> {
    private final ByteReader reader;
    private final CompilationUnitContext.Header cuHeader;
    private final ReferenceBytesConverter referenceBytesConverter;
    private final AttributeProcessor<T> attributeProcessor;
    private final long debugStrOffset;

    public DefaultAttributesReader(ByteReader reader, CompilationUnitContext.Header cuHeader, ReferenceBytesConverter referenceBytesConverter, AttributeProcessor<T> attributeProcessor, long debugStrOffset) {
        this.reader = reader;
        this.cuHeader = cuHeader;
        this.referenceBytesConverter = referenceBytesConverter;
        this.attributeProcessor = attributeProcessor;
        this.debugStrOffset = debugStrOffset;
    }

    @Override
    public T readAttributes(List<DebugAbbrevEntry.Attribute> attributes) throws IOException {
        for (DebugAbbrevEntry.Attribute attribute : attributes) {
            DefaultAttributesReader.processDebugInfoEntryAttribute(this.reader, this.cuHeader, this.referenceBytesConverter, attribute, this.attributeProcessor, this.debugStrOffset);
        }
        return this.attributeProcessor.finishProcessingAttributes();
    }

    private static void processDebugInfoEntryAttribute(ByteReader reader, CompilationUnitContext.Header cuHeader, ReferenceBytesConverter referenceBytesConverter, DebugAbbrevEntry.Attribute attribute, AttributeProcessor attributeProcessor, long debugStrOffset) throws IOException {
        switch (attribute.form) {
            case ADDR: {
                attributeProcessor.processAttribute(attribute.name, reader.readLong(cuHeader.addressSize));
                break;
            }
            case REF1: {
                attributeProcessor.processAttribute(attribute.name, referenceBytesConverter.asLongValue(reader.readBytes(1)) + cuHeader.offset);
                break;
            }
            case REF2: {
                attributeProcessor.processAttribute(attribute.name, referenceBytesConverter.asLongValue(reader.readBytes(2)) + cuHeader.offset);
                break;
            }
            case REF4: {
                attributeProcessor.processAttribute(attribute.name, referenceBytesConverter.asLongValue(reader.readBytes(4)) + cuHeader.offset);
                break;
            }
            case REF8: {
                attributeProcessor.processAttribute(attribute.name, referenceBytesConverter.asLongValue(reader.readBytes(8)) + cuHeader.offset);
                break;
            }
            case REF_UDATA: {
                attributeProcessor.processAttribute(attribute.name, (long)reader.readULEB128() + cuHeader.offset);
                break;
            }
            case REF_ADDR: {
                attributeProcessor.processAttribute(attribute.name, reader.readLong(cuHeader.version < 3 ? cuHeader.addressSize : cuHeader.referenceSize));
                break;
            }
            case SEC_OFFSET: {
                attributeProcessor.processAttribute(attribute.name, reader.readLong(cuHeader.referenceSize));
                break;
            }
            case BLOCK1: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, DefaultAttributesReader.readBytesWithBlockSize(reader, 1));
                break;
            }
            case BLOCK2: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, DefaultAttributesReader.readBytesWithBlockSize(reader, 2));
                break;
            }
            case BLOCK4: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, DefaultAttributesReader.readBytesWithBlockSize(reader, 4));
                break;
            }
            case BLOCK: 
            case EXPRLOC: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, DefaultAttributesReader.readBytesWithBlockSize(reader));
                break;
            }
            case DATA1: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, reader.readBytes(1));
                break;
            }
            case DATA2: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, reader.readBytes(2));
                break;
            }
            case DATA4: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, reader.readBytes(4));
                break;
            }
            case DATA8: 
            case REF_SIG8: {
                attributeProcessor.processAttribute(attribute.name, attribute.form, reader.readBytes(8));
                break;
            }
            case SDATA: {
                attributeProcessor.processAttribute(attribute.name, reader.readSLEB128());
                break;
            }
            case UDATA: {
                attributeProcessor.processAttribute(attribute.name, reader.readULEB128());
                break;
            }
            case FLAG: {
                attributeProcessor.processAttribute(attribute.name, reader.readLong(1));
                break;
            }
            case FLAG_PRESENT: {
                attributeProcessor.processAttribute(attribute.name, 1L);
                break;
            }
            case STRING: {
                attributeProcessor.processAttribute(attribute.name, reader.readNullTerminatedString(Charsets.UTF_8));
                break;
            }
            case STRP: {
                attributeProcessor.processAttribute(attribute.name, DefaultAttributesReader.readStringFromTable(reader, cuHeader.referenceSize, debugStrOffset));
                break;
            }
            default: {
                attributeProcessor.processAttribute(attribute.name, 0L);
            }
        }
    }

    private static byte[] readBytesWithBlockSize(ByteReader reader, int numBytes) throws IOException {
        int blockSize = reader.readInt(numBytes);
        return reader.readBytes(blockSize);
    }

    private static byte[] readBytesWithBlockSize(ByteReader reader) throws IOException {
        int blockSize = reader.readULEB128();
        return reader.readBytes(blockSize);
    }

    private static String readStringFromTable(ByteReader reader, int referenceSize, long debugStrOffset) throws IOException {
        long tableOffset = reader.readLong(referenceSize);
        long pos = reader.getCurrentOffset();
        reader.seek(debugStrOffset + tableOffset);
        String value = reader.readNullTerminatedString(Charsets.UTF_8);
        reader.seek(pos);
        return value;
    }
}

