/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.buildids;

import com.google.firebase.crashlytics.buildtools.buildids.BuildIdInfo;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineEntry;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRanges;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.EMachine;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfDataParser;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfFileHeader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSectionHeaders;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSymbol;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BuildIdInfoCollector {
    public List<BuildIdInfo> collect(File mergedNativeLibsPath) {
        ArrayList<BuildIdInfo> buildIdInfoList = new ArrayList<BuildIdInfo>();
        for (File file : FileUtils.listFiles(mergedNativeLibsPath)) {
            Optional<BuildIdInfo> buildIdInfo = this.getBuildIdInfo(file);
            buildIdInfo.ifPresent(buildIdInfoList::add);
        }
        return buildIdInfoList;
    }

    private Optional<BuildIdInfo> getBuildIdInfo(File file) {
        BuildIdInfoContentHandler contentHandler = new BuildIdInfoContentHandler(file.getName());
        try {
            ElfDataParser.parse(file, contentHandler, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return contentHandler.optionalBuildInfo();
    }

    private static String getBuildIdBytesToString(byte[] buildIdBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : buildIdBytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    class BuildIdInfoContentHandler
    implements ElfDataParser.ContentHandler {
        private String _libraryName;
        private String _arch;
        private String _buildId;

        BuildIdInfoContentHandler(String libraryName) {
            this._libraryName = libraryName;
        }

        @Override
        public void processElfHeader(ElfFileHeader fileHeader) {
            this._arch = EMachine.getMachineName(fileHeader.eMachine);
        }

        @Override
        public void processBuildId(byte[] buildId) {
            this._buildId = BuildIdInfoCollector.getBuildIdBytesToString(buildId);
        }

        public Optional<BuildIdInfo> optionalBuildInfo() {
            return this._buildId != null ? Optional.of(new BuildIdInfo(this._libraryName, this._arch, this._buildId)) : Optional.empty();
        }

        @Override
        public void processSectionHeaders(ElfSectionHeaders sectionHeaders) {
        }

        @Override
        public void processArmVersion(String armVersion) {
        }

        @Override
        public void startProcessingSymbols() {
        }

        @Override
        public void processElfSymbols(List<ElfSymbol> elfSymbols) {
        }

        @Override
        public void processDebugInfoCompilationUnit(NamedRanges namedRanges, List<DebugLineEntry> debugLineEntries) {
        }

        @Override
        public void endProcessingSymbols() {
        }
    }
}

