/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.CodeMappingException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad.BreakpadRecords;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class BreakpadSymbolGenerator
implements NativeSymbolGenerator {
    private static final String OS_WINDOWS = "windows";
    private static final String OS_MAC = "macos";
    private static final String OS_LINUX = "linux";
    private static final String[] MINGW_DLLS = new String[]{"libgcc_s_seh-1.dll", "libssp-0.dll", "libstdc++-6.dll", "libwinpthread-1.dll"};
    private static final Set<PosixFilePermission> DUMP_SYMS_PERMISSIONS = Collections.unmodifiableSet(new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE)));
    private final File dumpSymsBin;

    public static File extractDefaultDumpSymsBinary(File destPath) throws IOException {
        String osString = BreakpadSymbolGenerator.getOsForDumpSyms();
        File outputFile = new File(destPath, OS_WINDOWS.equals(osString) ? "dump_syms.exe" : "dump_syms.bin");
        if (outputFile.exists()) {
            Buildtools.logD("Skipping dumpsyms extraction, file exists: " + outputFile.getAbsolutePath());
            return outputFile;
        }
        String resource = "dump_syms/" + osString + "/dump_syms.bin";
        Buildtools.logD("Extracting dump_syms from " + resource + " to " + outputFile.getAbsolutePath());
        BreakpadSymbolGenerator.extractResource(resource, outputFile);
        if (!OS_WINDOWS.equals(osString)) {
            Files.setPosixFilePermissions(outputFile.toPath(), DUMP_SYMS_PERMISSIONS);
        } else {
            boolean result = outputFile.setExecutable(true);
            if (!result) {
                Buildtools.logW("File#setExecutable() failed for " + outputFile.getAbsolutePath() + "; library extracted without setting permissions.");
            }
            Buildtools.logD("Extracting mingw DLLs to " + destPath);
            for (String dll : MINGW_DLLS) {
                String dllResource = "dump_syms/windows/" + dll;
                BreakpadSymbolGenerator.extractResource(dllResource, new File(destPath, dll));
            }
        }
        return outputFile;
    }

    private static void extractResource(String pathToResource, File outputFile) throws IOException {
        InputStream binStream = BreakpadSymbolGenerator.class.getClassLoader().getResourceAsStream(pathToResource);
        FileOutputStream outStream = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)binStream, (OutputStream)outStream);
        binStream.close();
        ((OutputStream)outStream).close();
    }

    private static String getOsForDumpSyms() throws IOException {
        String osProp = System.getProperty("os.name").toLowerCase();
        if (osProp.startsWith(OS_WINDOWS)) {
            return OS_WINDOWS;
        }
        if (osProp.startsWith("mac")) {
            return OS_MAC;
        }
        if (osProp.startsWith(OS_LINUX)) {
            return OS_LINUX;
        }
        throw new IOException("Cannot extract dump_syms, unexpected os.name: " + osProp);
    }

    public BreakpadSymbolGenerator(File dumpSymsBin) {
        this.dumpSymsBin = dumpSymsBin;
        Buildtools.logD("Breakpad symbol generator initialized: " + dumpSymsBin.getAbsolutePath());
    }

    @Override
    public File generateSymbols(File nativeLib, File symbolFileOutputDir) throws IOException, CodeMappingException {
        Buildtools.logD("Crashlytics generating Breakpad Symbol file for: " + nativeLib.getAbsolutePath());
        File tempOutputFile = File.createTempFile(nativeLib.getName(), ".tmp", symbolFileOutputDir);
        Buildtools.logD("Extracting Breakpad symbols to temp file: " + tempOutputFile.getAbsolutePath());
        Process proc = new ProcessBuilder(this.dumpSymsBin.getAbsolutePath(), nativeLib.getAbsolutePath()).redirectOutput(tempOutputFile).start();
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Dump symbols was unexpectedly interrupted.", e);
        }
        if (proc.exitValue() != 0) {
            throw new IOException("Breakpad symbol generation failed (exit=" + proc.exitValue() + "), see STDERR");
        }
        BreakpadRecords breakpadRecords = BreakpadRecords.createFromBreakpadFile(tempOutputFile);
        String codeId = breakpadRecords.getCodeId() != null ? breakpadRecords.getCodeId() : breakpadRecords.getModuleId();
        Buildtools.logD("GNU Build Id for " + nativeLib.getAbsolutePath() + ": " + codeId);
        String symbolFileBasename = NativeSymbolGenerator.createSymbolFileBasename(nativeLib.getName(), breakpadRecords.getArchitecture(), codeId);
        File breakpadOutputFile = new File(symbolFileOutputDir, symbolFileBasename + ".sym");
        Buildtools.logD("Renaming Breakpad symbol file to: " + breakpadOutputFile.getAbsolutePath());
        Files.move(tempOutputFile.toPath(), breakpadOutputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return breakpadOutputFile;
    }
}

