/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSym;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymFactory;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineEntry;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRange;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRanges;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.EMachine;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfDataParser;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfFileHeader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSectionHeaders;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSymbol;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ElfCSymFactory
implements CSymFactory {
    private static final String ELF_CSYM_TYPE = "elf_symtab";
    private static final String DWARF_CSYM_TYPE = "dwarf_debug";
    private final boolean _featureUseDebugInfo;

    public ElfCSymFactory(boolean featureUseDebugInfo) {
        this._featureUseDebugInfo = featureUseDebugInfo;
    }

    @Override
    public CSym createCSymFromFile(File unstrippedLib) throws CSymException, IOException {
        if (!unstrippedLib.isFile()) {
            throw new IllegalArgumentException("Invalid object file: " + unstrippedLib);
        }
        CSymFactoryHandler handler = new CSymFactoryHandler(this._featureUseDebugInfo);
        ElfDataParser.parse(unstrippedLib, handler, this._featureUseDebugInfo);
        return handler.getBuilder().build();
    }

    private static final class CSymFactoryHandler
    implements ElfDataParser.ContentHandler {
        private final boolean _featureUseDebugInfo;
        private final Map<Long, DebugLineGroup> _elfSymbolGroups = new HashMap<Long, DebugLineGroup>();
        private final TreeMap<Long, ElfSymbol> _sortedSymbolIndex = new TreeMap();
        private CSym.Builder _builder;
        private int _arch;
        private String _uuid;
        private String _archName;
        private boolean _isArm;
        private boolean _hasDebugInfo;

        public CSymFactoryHandler(boolean useDebugInfo) {
            this._featureUseDebugInfo = useDebugInfo;
        }

        @Override
        public void processElfHeader(ElfFileHeader fileHeader) {
            this._arch = fileHeader.eMachine;
            this._isArm = this._arch == 40 || this._arch == 183;
            this._archName = EMachine.getMachineName(this._arch);
        }

        @Override
        public void processSectionHeaders(ElfSectionHeaders sectionHeaders) {
            this._hasDebugInfo = sectionHeaders.getHeaderByName(".debug_info").isPresent();
        }

        @Override
        public void processBuildId(byte[] buildId) {
            this._uuid = CSymFactoryHandler.getBuildIdString(buildId);
        }

        @Override
        public void processArmVersion(String armVersion) {
            if (this._arch == 40) {
                this._archName = this._archName + String.format("v%s", armVersion);
            }
        }

        @Override
        public void startProcessingSymbols() {
            String type = this._featureUseDebugInfo && this._hasDebugInfo ? ElfCSymFactory.DWARF_CSYM_TYPE : ElfCSymFactory.ELF_CSYM_TYPE;
            this._builder = new CSym.Builder(this._uuid, type, this._archName);
            String log = this._hasDebugInfo ? (this._featureUseDebugInfo ? "Using DWARF data for cSYM generation." : "Using ELF symbols with DWARF line number information for cSYM generation.") : "Using ELF data for cSYM generation.";
            Buildtools.logD(log);
        }

        @Override
        public void processElfSymbols(List<ElfSymbol> elfSymbols) {
            if (!this._hasDebugInfo) {
                CSymFactoryHandler.populateBuilderWithElfSymbols(this._builder, elfSymbols);
                return;
            }
            if (!this._featureUseDebugInfo) {
                CSymFactoryHandler.indexElfSymbols(elfSymbols, this._sortedSymbolIndex, this._elfSymbolGroups, this._isArm);
            }
        }

        @Override
        public void processDebugInfoCompilationUnit(NamedRanges namedRanges, List<DebugLineEntry> debugLineEntries) {
            if (!this._featureUseDebugInfo) {
                CSymFactoryHandler.populateElfSymbolGroups(debugLineEntries, this._sortedSymbolIndex, this._elfSymbolGroups, this._isArm);
                return;
            }
            List<DebugLineGroup> debugLineGroups = CSymFactoryHandler.createDwarfDebugLineGroups(namedRanges, debugLineEntries);
            CSymFactoryHandler.populateBuilderWithDebugLineGroups(this._builder, debugLineGroups);
        }

        @Override
        public void endProcessingSymbols() {
            if (!this._featureUseDebugInfo && this._hasDebugInfo) {
                ArrayList debugLineGroups = Lists.newArrayList(this._elfSymbolGroups.values());
                CSymFactoryHandler.populateBuilderWithDebugLineGroups(this._builder, debugLineGroups);
            }
        }

        public CSym.Builder getBuilder() {
            return this._builder;
        }

        private static void indexElfSymbols(List<ElfSymbol> elfSymbols, TreeMap<Long, ElfSymbol> symbolIndex, Map<Long, DebugLineGroup> elfSymbolGroups, boolean isArm) {
            for (ElfSymbol symbol : elfSymbols) {
                if (CSymFactoryHandler.isArmMappingSymbol(symbol)) continue;
                long symbolAddr = isArm ? symbol.stValue & 0xFFFFFFFFFFFFFFFEL : symbol.stValue;
                symbolIndex.put(symbolAddr, symbol);
                if (!CSymFactoryHandler.isNecessarySymbol(symbol)) continue;
                elfSymbolGroups.put(symbolAddr, new DebugLineGroup(symbol.stNameString, symbolAddr, symbol.stSize));
            }
        }

        private static void populateElfSymbolGroups(List<DebugLineEntry> debugLineEntries, TreeMap<Long, ElfSymbol> symbolIndex, Map<Long, DebugLineGroup> elfSymbolGroups, boolean isArm) {
            for (DebugLineEntry debugLineEntry : debugLineEntries) {
                long address = debugLineEntry.address;
                ElfSymbol foundSymbol = symbolIndex.containsKey(address) ? symbolIndex.get(address) : CSymFactoryHandler.findEnclosingElfSymbol(symbolIndex, address);
                long foundSymbolAddr = isArm ? foundSymbol.stValue & 0xFFFFFFFFFFFFFFFEL : foundSymbol.stValue;
                DebugLineGroup foundLineGroup = elfSymbolGroups.get(foundSymbolAddr);
                if (foundLineGroup == null) continue;
                foundLineGroup.add(debugLineEntry);
            }
        }

        private static List<DebugLineGroup> createDwarfDebugLineGroups(NamedRanges namedRanges, List<DebugLineEntry> debugLineEntries) {
            HashMap lineGroups = Maps.newHashMap();
            for (DebugLineEntry entry : debugLineEntries) {
                Optional<NamedRange> range = namedRanges.rangeFor(entry.address);
                Optional groupFromRangeOpt = range.transform((Function)new Function<NamedRange, DebugLineGroup>(){

                    public DebugLineGroup apply(NamedRange input) {
                        return new DebugLineGroup(input.name, input.start, input.end - input.start);
                    }
                });
                if (!groupFromRangeOpt.isPresent()) continue;
                DebugLineGroup groupFromRange = (DebugLineGroup)groupFromRangeOpt.get();
                DebugLineGroup group = (DebugLineGroup)Optional.fromNullable(lineGroups.get(groupFromRange.symbolAddr)).or((Object)groupFromRange);
                group.add(entry);
                lineGroups.put(group.symbolAddr, group);
            }
            return Lists.newArrayList(lineGroups.values());
        }

        private static void populateBuilderWithElfSymbols(CSym.Builder builder, List<ElfSymbol> elfSymbols) {
            for (ElfSymbol symbol : elfSymbols) {
                if (!CSymFactoryHandler.isNecessarySymbol(symbol)) continue;
                builder.addRange(symbol.stValue, symbol.stSize, symbol.stNameString);
            }
        }

        private static void populateBuilderWithDebugLineGroups(CSym.Builder builder, List<DebugLineGroup> symbolGroups) {
            for (DebugLineGroup lineGroup : symbolGroups) {
                String symbolName = lineGroup.symbolName;
                long symbolAddr = lineGroup.symbolAddr;
                long symbolSize = lineGroup.symbolSize;
                if (lineGroup.hasEntries()) {
                    List<DebugLineEntry> entryList = lineGroup.entryList();
                    int endIndex = entryList.size() - 1;
                    for (int i = 0; i < endIndex; ++i) {
                        DebugLineEntry curr = entryList.get(i);
                        DebugLineEntry next = entryList.get(i + 1);
                        long currSize = next.address - curr.address;
                        builder.addRange(curr.address, currSize, symbolName, curr.file, curr.lineNumber);
                    }
                    DebugLineEntry last = entryList.get(endIndex);
                    long lastSize = symbolAddr + symbolSize - last.address;
                    builder.addRange(last.address, lastSize, symbolName, last.file, last.lineNumber);
                    continue;
                }
                builder.addRange(symbolAddr, symbolSize, symbolName);
            }
        }

        private static ElfSymbol findEnclosingElfSymbol(TreeMap<Long, ElfSymbol> index, long address) {
            Long prevKey = index.lowerKey(address);
            return prevKey != null ? index.get(prevKey) : null;
        }

        private static boolean isNecessarySymbol(ElfSymbol symbol) {
            return symbol != null && (symbol.stInfo & 0xF) == 2 && symbol.stSize != 0L;
        }

        private static boolean isArmMappingSymbol(ElfSymbol symbol) {
            return symbol != null && symbol.stNameString != null && (symbol.stNameString.startsWith("$a") || symbol.stNameString.startsWith("$d") || symbol.stNameString.startsWith("$t"));
        }

        private static String getBuildIdString(byte[] identifierBytes) {
            return CSymFactoryHandler.buildIdBytesToString(identifierBytes);
        }

        private static String buildIdBytesToString(byte[] buildIdBytes) {
            StringBuilder sb = new StringBuilder();
            for (byte b : buildIdBytes) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
    }

    private static class DebugLineGroup {
        private static final Comparator<DebugLineEntry> ADDRESS_COMPARATOR = new Comparator<DebugLineEntry>(){

            @Override
            public int compare(DebugLineEntry lhs, DebugLineEntry rhs) {
                long x = lhs.address;
                long y = rhs.address;
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        };
        private final TreeSet<DebugLineEntry> _lineEntries = new TreeSet<DebugLineEntry>(ADDRESS_COMPARATOR);
        public final String symbolName;
        public final long symbolAddr;
        public final long symbolSize;

        public DebugLineGroup(String symbolName, long symbolAddr, long symbolSize) {
            this.symbolName = symbolName;
            this.symbolAddr = symbolAddr;
            this.symbolSize = symbolSize;
        }

        public void add(DebugLineEntry entry) {
            this._lineEntries.add(entry);
        }

        public boolean hasEntries() {
            return !this._lineEntries.isEmpty();
        }

        public List<DebugLineEntry> entryList() {
            return new ArrayList<DebugLineEntry>(this._lineEntries);
        }
    }
}

