/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.common.collect.ImmutableList;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymIdStrategy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class AndroidCSymIdStrategy
implements CSymIdStrategy {
    private static final String NDKLIBSOUT_INCORRECT_CONFIG_MSG = "Is the -androidNdkLibsOut setting configured correctly?";
    private final File _ndkLibsOutDir;

    public AndroidCSymIdStrategy(File ndkLibsOutDir) {
        this._ndkLibsOutDir = ndkLibsOutDir;
    }

    public static String createSha1Hex(File f) throws IOException {
        BufferedInputStream in = null;
        String shaHex = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            shaHex = DigestUtils.shaHex((InputStream)in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return shaHex;
    }

    @Override
    public String createCSymIdForLibrary(File unstrippedLibrary) throws IOException {
        if (!this._ndkLibsOutDir.isDirectory()) {
            throw new IOException(String.format("Could not find NDK libs output directory '%s'. %s", this._ndkLibsOutDir.getAbsolutePath(), NDKLIBSOUT_INCORRECT_CONFIG_MSG));
        }
        String parentFolder = unstrippedLibrary.getParentFile().getName();
        String arch = parentFolder.equals("armeabi-v7a-hard") ? "armeabi-v7a" : parentFolder;
        ImmutableList matchingFiles = ImmutableList.copyOf((Collection)FileUtils.listFiles((File)this._ndkLibsOutDir, (IOFileFilter)new MatchingStrippedFileFilter(unstrippedLibrary, arch), (IOFileFilter)TrueFileFilter.INSTANCE));
        if (matchingFiles.isEmpty()) {
            throw new FileNotFoundException("File matching " + unstrippedLibrary + " in " + this._ndkLibsOutDir + " was not found. " + NDKLIBSOUT_INCORRECT_CONFIG_MSG);
        }
        if (matchingFiles.size() > 1) {
            throw new IllegalArgumentException("Multiple files matching " + unstrippedLibrary + " in " + this._ndkLibsOutDir + " were found. " + NDKLIBSOUT_INCORRECT_CONFIG_MSG);
        }
        File libFile = (File)matchingFiles.get(0);
        if (!libFile.exists()) {
            throw new FileNotFoundException(libFile.getAbsolutePath() + " was not found. " + NDKLIBSOUT_INCORRECT_CONFIG_MSG);
        }
        return AndroidCSymIdStrategy.createSha1Hex(libFile);
    }

    private final class MatchingStrippedFileFilter
    implements IOFileFilter {
        private final File _objFile;
        private final String _architecture;

        MatchingStrippedFileFilter(File objFile, String architecture) {
            this._objFile = objFile;
            this._architecture = architecture;
        }

        public boolean accept(File file) {
            return this.accept(file, file.getName());
        }

        public boolean accept(File file, String name) {
            return name.equals(this._objFile.getName()) && file.getParentFile().getName().equals(this._architecture);
        }
    }
}

