/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal.rollouts;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import com.google.firebase.remoteconfig.internal.rollouts.RolloutsStateFactory;
import com.google.firebase.remoteconfig.interop.rollouts.RolloutsState;
import com.google.firebase.remoteconfig.interop.rollouts.RolloutsStateSubscriber;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class RolloutsStateSubscriptionsHandler {
    private ConfigCacheClient activatedConfigsCache;
    private RolloutsStateFactory rolloutsStateFactory;
    private Executor executor;
    private Set<RolloutsStateSubscriber> subscribers = Collections.newSetFromMap(new ConcurrentHashMap());

    public RolloutsStateSubscriptionsHandler(@NonNull ConfigCacheClient activatedConfigsCache, @NonNull RolloutsStateFactory rolloutsStateFactory, @NonNull Executor executor) {
        this.activatedConfigsCache = activatedConfigsCache;
        this.rolloutsStateFactory = rolloutsStateFactory;
        this.executor = executor;
    }

    public void registerRolloutsStateSubscriber(@NonNull RolloutsStateSubscriber subscriber) {
        this.subscribers.add(subscriber);
        Task<ConfigContainer> activatedConfigsCacheTask = this.activatedConfigsCache.get();
        activatedConfigsCacheTask.addOnSuccessListener(this.executor, unused -> {
            try {
                ConfigContainer activatedConfigsCache = (ConfigContainer)activatedConfigsCacheTask.getResult();
                if (activatedConfigsCache != null) {
                    RolloutsState rolloutsState = this.rolloutsStateFactory.getActiveRolloutsState(activatedConfigsCache);
                    this.executor.execute(() -> subscriber.onRolloutsStateChanged(rolloutsState));
                }
            }
            catch (FirebaseRemoteConfigException e) {
                Log.w((String)"FirebaseRemoteConfig", (String)"Exception publishing RolloutsState to subscriber. Continuing to listen for changes.", (Throwable)((Object)e));
            }
        });
    }

    public void publishActiveRolloutsState(@NonNull ConfigContainer configContainer) {
        try {
            RolloutsState activeRolloutsState = this.rolloutsStateFactory.getActiveRolloutsState(configContainer);
            for (RolloutsStateSubscriber subscriber : this.subscribers) {
                this.executor.execute(() -> subscriber.onRolloutsStateChanged(activeRolloutsState));
            }
        }
        catch (FirebaseRemoteConfigException e) {
            Log.w((String)"FirebaseRemoteConfig", (String)"Exception publishing RolloutsState to subscribers. Continuing to listen for changes.", (Throwable)((Object)e));
        }
    }
}

