/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import com.google.firebase.remoteconfig.internal.ConfigStorageClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@AnyThread
public class ConfigCacheClient {
    static final long DISK_READ_TIMEOUT_IN_SECONDS = 5L;
    @GuardedBy(value="ConfigCacheClient.class")
    private static final Map<String, ConfigCacheClient> clientInstances = new HashMap<String, ConfigCacheClient>();
    private final Executor executor;
    private final ConfigStorageClient storageClient;
    @GuardedBy(value="this")
    @Nullable
    private Task<ConfigContainer> cachedContainerTask;
    private static final Executor DIRECT_EXECUTOR = Runnable::run;

    private ConfigCacheClient(Executor executor, ConfigStorageClient storageClient) {
        this.executor = executor;
        this.storageClient = storageClient;
        this.cachedContainerTask = null;
    }

    @Nullable
    public ConfigContainer getBlocking() {
        return this.getBlocking(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    ConfigContainer getBlocking(long diskReadTimeoutInSeconds) {
        ConfigCacheClient configCacheClient = this;
        synchronized (configCacheClient) {
            if (this.cachedContainerTask != null && this.cachedContainerTask.isSuccessful()) {
                return (ConfigContainer)this.cachedContainerTask.getResult();
            }
        }
        try {
            return ConfigCacheClient.await(this.get(), diskReadTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Log.d((String)"FirebaseRemoteConfig", (String)"Reading from storage file failed.", (Throwable)e);
            return null;
        }
    }

    public Task<ConfigContainer> put(ConfigContainer configContainer) {
        return this.put(configContainer, true);
    }

    public Task<ConfigContainer> put(ConfigContainer configContainer, boolean shouldUpdateInMemoryContainer) {
        return Tasks.call((Executor)this.executor, () -> this.storageClient.write(configContainer)).onSuccessTask(this.executor, unusedVoid -> {
            if (shouldUpdateInMemoryContainer) {
                this.updateInMemoryConfigContainer(configContainer);
            }
            return Tasks.forResult((Object)configContainer);
        });
    }

    public synchronized Task<ConfigContainer> get() {
        block3: {
            block2: {
                if (this.cachedContainerTask == null) break block2;
                if (!this.cachedContainerTask.isComplete() || this.cachedContainerTask.isSuccessful()) break block3;
            }
            this.cachedContainerTask = Tasks.call((Executor)this.executor, this.storageClient::read);
        }
        return this.cachedContainerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConfigCacheClient configCacheClient = this;
        synchronized (configCacheClient) {
            this.cachedContainerTask = Tasks.forResult(null);
        }
        this.storageClient.clear();
    }

    private synchronized void updateInMemoryConfigContainer(ConfigContainer configContainer) {
        this.cachedContainerTask = Tasks.forResult((Object)configContainer);
    }

    @VisibleForTesting
    @Nullable
    synchronized Task<ConfigContainer> getCachedContainerTask() {
        return this.cachedContainerTask;
    }

    public static synchronized ConfigCacheClient getInstance(Executor executor, ConfigStorageClient storageClient) {
        String fileName = storageClient.getFileName();
        if (!clientInstances.containsKey(fileName)) {
            clientInstances.put(fileName, new ConfigCacheClient(executor, storageClient));
        }
        return clientInstances.get(fileName);
    }

    @VisibleForTesting
    public static synchronized void clearInstancesForTest() {
        clientInstances.clear();
    }

    private static <TResult> TResult await(Task<TResult> task, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        AwaitListener waiter = new AwaitListener();
        task.addOnSuccessListener(DIRECT_EXECUTOR, waiter);
        task.addOnFailureListener(DIRECT_EXECUTOR, waiter);
        task.addOnCanceledListener(DIRECT_EXECUTOR, waiter);
        if (!waiter.await(timeout, unit)) {
            throw new TimeoutException("Task await timed out.");
        }
        if (task.isSuccessful()) {
            return (TResult)task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static class AwaitListener<TResult>
    implements OnSuccessListener<TResult>,
    OnFailureListener,
    OnCanceledListener {
        private final CountDownLatch latch = new CountDownLatch(1);

        private AwaitListener() {
        }

        public void onSuccess(TResult o) {
            this.latch.countDown();
        }

        public void onFailure(@NonNull Exception e) {
            this.latch.countDown();
        }

        public void onCanceled() {
            this.latch.countDown();
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }
    }
}

