/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import androidx.annotation.NonNull;
import com.google.firebase.remoteconfig.internal.ConfigFetchHandler;

public class FirebaseRemoteConfigSettings {
    private final long fetchTimeoutInSeconds;
    private final long minimumFetchInterval;

    private FirebaseRemoteConfigSettings(Builder builder) {
        this.fetchTimeoutInSeconds = builder.fetchTimeoutInSeconds;
        this.minimumFetchInterval = builder.minimumFetchInterval;
    }

    public long getFetchTimeoutInSeconds() {
        return this.fetchTimeoutInSeconds;
    }

    public long getMinimumFetchIntervalInSeconds() {
        return this.minimumFetchInterval;
    }

    @NonNull
    public Builder toBuilder() {
        Builder frcBuilder = new Builder();
        frcBuilder.setFetchTimeoutInSeconds(this.getFetchTimeoutInSeconds());
        frcBuilder.setMinimumFetchIntervalInSeconds(this.getMinimumFetchIntervalInSeconds());
        return frcBuilder;
    }

    public static class Builder {
        private long fetchTimeoutInSeconds = 60L;
        private long minimumFetchInterval = ConfigFetchHandler.DEFAULT_MINIMUM_FETCH_INTERVAL_IN_SECONDS;

        @NonNull
        public Builder setFetchTimeoutInSeconds(long duration) throws IllegalArgumentException {
            if (duration < 0L) {
                throw new IllegalArgumentException(String.format("Fetch connection timeout has to be a non-negative number. %d is an invalid argument", duration));
            }
            this.fetchTimeoutInSeconds = duration;
            return this;
        }

        @NonNull
        public Builder setMinimumFetchIntervalInSeconds(long duration) {
            if (duration < 0L) {
                throw new IllegalArgumentException("Minimum interval between fetches has to be a non-negative number. " + duration + " is an invalid argument");
            }
            this.minimumFetchInterval = duration;
            return this;
        }

        public long getFetchTimeoutInSeconds() {
            return this.fetchTimeoutInSeconds;
        }

        public long getMinimumFetchIntervalInSeconds() {
            return this.minimumFetchInterval;
        }

        @NonNull
        public FirebaseRemoteConfigSettings build() {
            return new FirebaseRemoteConfigSettings(this);
        }
    }
}

