/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzdyw;
import com.google.android.gms.internal.zzflr;
import com.google.android.gms.internal.zzfmv;
import com.google.android.gms.measurement.AppMeasurement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Hide
public final class zzdyx {
    @Nullable
    private static AppMeasurement zzde(Context context) {
        try {
            return AppMeasurement.getInstance((Context)context);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private static boolean zzey(Context context) {
        if (zzdyx.zzde(context) == null) {
            if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                Log.v((String)"FirebaseAbtUtil", (String)"Firebase Analytics not available");
            }
            return false;
        }
        try {
            Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                Log.v((String)"FirebaseAbtUtil", (String)"Firebase Analytics library is missing support for abt. Please update to a more recent version.");
            }
            return false;
        }
    }

    private static void zza(@NonNull AppMeasurement appMeasurement, @NonNull Context context, @NonNull String string, @NonNull zzfmv zzfmv2, @NonNull zzdyw zzdyw2, int n) {
        Object object;
        if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
            String string2 = zzfmv2.zzpzs;
            object = zzfmv2.zzpzt;
            Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(object).length()).append("_SEI: ").append(string2).append(" ").append((String)object).toString());
        }
        try {
            Object object2;
            Object object3;
            String string3;
            Object object4;
            Object object5;
            Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty");
            object = zzdyx.zza(appMeasurement, string);
            String string4 = string;
            AppMeasurement appMeasurement2 = appMeasurement;
            int n2 = zzdyx.zzb(appMeasurement2, string4);
            if (zzdyx.zza(appMeasurement2, string4).size() >= n2) {
                appMeasurement2 = zzfmv2;
                if ((appMeasurement2.zzqac != 0 ? appMeasurement2.zzqac : 1) == 1) {
                    object5 = object.get(0);
                    object4 = zzdyx.zzbe(object5);
                    string3 = zzdyx.zzbf(object5);
                    if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                        Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(38 + String.valueOf(object4).length()).append("Clearing _E due to overflow policy: [").append((String)object4).append("]").toString());
                    }
                    zzdyx.zza(context, string, object4, string3, zzdyx.zza(zzfmv2, zzdyw2));
                } else {
                    if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                        String string5 = zzfmv2.zzpzs;
                        String string6 = zzfmv2.zzpzt;
                        Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(44 + String.valueOf(string5).length() + String.valueOf(string6).length()).append("_E won't be set due to overflow policy. [").append(string5).append(", ").append(string6).append("]").toString());
                    }
                    return;
                }
            }
            object5 = object.iterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                string3 = zzdyx.zzbe(object4);
                String string7 = zzdyx.zzbf(object4);
                if (!string3.equals(zzfmv2.zzpzs) || string7.equals(zzfmv2.zzpzt) || !Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) continue;
                Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(77 + String.valueOf(string3).length() + String.valueOf(string7).length()).append("Clearing _E, as only one _V of the same _E can be set atany given time: [").append(string3).append(", ").append(string7).append("].").toString());
                zzdyx.zza(context, string, string3, string7, zzdyx.zza(zzfmv2, zzdyw2));
            }
            object5 = zzdyx.zza(zzfmv2, string, zzdyw2);
            if (object5 == null) {
                if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                    object4 = zzfmv2.zzpzs;
                    string3 = zzfmv2.zzpzt;
                    Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(42 + String.valueOf(object4).length() + String.valueOf(string3).length()).append("Could not create _CUP for: [").append((String)object4).append(", ").append(string3).append("]. Skipping.").toString());
                }
                return;
            }
            String string8 = string;
            Object object6 = object5;
            zzdyw zzdyw3 = zzdyw2;
            string4 = zzfmv2;
            appMeasurement2 = appMeasurement;
            if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                object3 = ((zzfmv)string4).zzpzs;
                object2 = ((zzfmv)string4).zzpzt;
                String string9 = ((zzfmv)string4).zzpzv;
                Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(27 + String.valueOf(object3).length() + String.valueOf(object2).length() + String.valueOf(string9).length()).append("Setting _CUP for _E: [").append((String)object3).append(", ").append((String)object2).append(", ").append(string9).append("]").toString());
            }
            try {
                object3 = Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty");
                object2 = AppMeasurement.class.getDeclaredMethod("setConditionalUserProperty", new Class[]{object3});
                ((Method)object2).setAccessible(true);
                zzdyw zzdyw4 = zzdyw3;
                String string10 = string4;
                appMeasurement2.logEventInternal(string8, !TextUtils.isEmpty((CharSequence)((zzfmv)string10).zzpzx) ? ((zzfmv)string10).zzpzx : zzdyw4.zzbsy(), zzdyx.zza((zzfmv)string4));
                ((Method)object2).invoke((Object)appMeasurement2, object6);
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
                return;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
            return;
        }
    }

    @Nullable
    private static Object zza(@NonNull zzfmv zzfmv2, @NonNull String string, @NonNull zzdyw zzdyw2) {
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty");
            Bundle bundle = zzdyx.zza(zzfmv2);
            var3_3 = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            clazz.getField("mOrigin").set(var3_3, string);
            clazz.getField("mCreationTimestamp").set(var3_3, zzfmv2.zzpzu);
            clazz.getField("mName").set(var3_3, zzfmv2.zzpzs);
            clazz.getField("mValue").set(var3_3, zzfmv2.zzpzt);
            String string2 = TextUtils.isEmpty((CharSequence)zzfmv2.zzpzv) ? null : zzfmv2.zzpzv;
            clazz.getField("mTriggerEventName").set(var3_3, string2);
            zzdyw zzdyw3 = zzdyw2;
            zzfmv zzfmv3 = zzfmv2;
            clazz.getField("mTimedOutEventName").set(var3_3, !TextUtils.isEmpty((CharSequence)zzfmv3.zzqaa) ? zzfmv3.zzqaa : zzdyw3.zzbta());
            clazz.getField("mTimedOutEventParams").set(var3_3, bundle);
            clazz.getField("mTriggerTimeout").set(var3_3, zzfmv2.zzpzw);
            zzdyw3 = zzdyw2;
            zzfmv3 = zzfmv2;
            clazz.getField("mTriggeredEventName").set(var3_3, !TextUtils.isEmpty((CharSequence)zzfmv3.zzpzy) ? zzfmv3.zzpzy : zzdyw3.zzbsz());
            clazz.getField("mTriggeredEventParams").set(var3_3, bundle);
            clazz.getField("mTimeToLive").set(var3_3, zzfmv2.zzgoc);
            zzdyw3 = zzdyw2;
            zzfmv3 = zzfmv2;
            clazz.getField("mExpiredEventName").set(var3_3, !TextUtils.isEmpty((CharSequence)zzfmv3.zzqab) ? zzfmv3.zzqab : zzdyw3.zzbtb());
            clazz.getField("mExpiredEventParams").set(var3_3, bundle);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
        }
        return var3_3;
    }

    private static Bundle zza(@NonNull zzfmv zzfmv2) {
        return zzdyx.zzay(zzfmv2.zzpzs, zzfmv2.zzpzt);
    }

    private static Bundle zzay(@NonNull String string, @NonNull String string2) {
        Bundle bundle = new Bundle();
        bundle.putString(string, string2);
        return bundle;
    }

    private static List<Object> zza(@NonNull AppMeasurement appMeasurement, @NonNull String string) {
        List<Object> list = new ArrayList<Object>();
        try {
            Method method = AppMeasurement.class.getDeclaredMethod("getConditionalUserProperties", String.class, String.class);
            method.setAccessible(true);
            list = (List)method.invoke((Object)appMeasurement, string, "");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
        }
        if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
            int n = list.size();
            Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(55 + String.valueOf(string).length()).append("Number of currently set _Es for origin: ").append(string).append(" is ").append(n).toString());
        }
        return list;
    }

    public static void zza(@NonNull Context context, @NonNull String string, @NonNull List<byte[]> list, int n, @NonNull zzdyw zzdyw2, long l) {
        if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
            String string2 = String.valueOf(string);
            Log.v((String)"FirebaseAbtUtil", (String)(string2.length() != 0 ? "_UE called by ".concat(string2) : new String("_UE called by ")));
        }
        if (!zzdyx.zzey(context)) {
            return;
        }
        AppMeasurement appMeasurement = zzdyx.zzde(context);
        try {
            String string3;
            String string4;
            Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty");
            List<Object> list2 = zzdyx.zza(appMeasurement, string);
            new ArrayList();
            List<zzfmv> list3 = zzdyx.zzb(list, list2);
            for (Object object : zzdyx.zzc(list, list2)) {
                string4 = zzdyx.zzbe(object);
                string3 = zzdyx.zzbf(object);
                if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                    Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(30 + String.valueOf(string4).length()).append("Clearing _E as part of _UE: [").append(string4).append("]").toString());
                }
                zzdyx.zza(context, string, string4, string3, zzdyx.zza(null, zzdyw2));
            }
            for (zzfmv zzfmv2 : list3) {
                long l2;
                if (zzfmv2.zzpzu > l) {
                    string4 = zzfmv2.zzpzs;
                    string3 = zzfmv2.zzpzt;
                    l2 = zzfmv2.zzpzu;
                    Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(106 + String.valueOf(string4).length() + String.valueOf(string3).length()).append("Setting _E as part of _UE: [").append(string4).append(", ").append(string3).append(", ").append(l2).append("], latestOriginKnownExpStartTime: ").append(l).toString());
                    zzdyx.zza(appMeasurement, context, string, zzfmv2, zzdyw2, 1);
                    continue;
                }
                if (!Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) continue;
                string4 = zzfmv2.zzpzs;
                string3 = zzfmv2.zzpzt;
                l2 = zzfmv2.zzpzu;
                Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(118 + String.valueOf(string4).length() + String.valueOf(string3).length()).append("Not setting _E, due to lastUpdateTime: [").append(string4).append(", ").append(string3).append(", ").append(l2).append("], latestOriginKnownExpStartTime: ").append(l).toString());
            }
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
            return;
        }
    }

    private static String zzbe(@NonNull Object object) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return (String)Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty").getField("mName").get(object);
    }

    private static String zzbf(@NonNull Object object) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return (String)Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty").getField("mValue").get(object);
    }

    private static List<zzfmv> zzb(@NonNull List<byte[]> list, @NonNull List<Object> list2) {
        ArrayList<zzfmv> arrayList = new ArrayList<zzfmv>();
        Iterator<byte[]> iterator = list.iterator();
        while (iterator.hasNext()) {
            zzfmv zzfmv2 = zzdyx.zzam(iterator.next());
            if (zzfmv2 == null) {
                if (!Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) continue;
                Log.v((String)"FirebaseAbtUtil", (String)"Couldn't deserialize the payload; skipping.");
                continue;
            }
            boolean bl = false;
            for (Object object : list2) {
                try {
                    Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty");
                    zzdyx.zzbe(object);
                    String string = zzdyx.zzbf(object);
                    if (!zzfmv2.zzpzs.equals(zzdyx.zzbe(object)) || !zzfmv2.zzpzt.equals(string)) continue;
                    bl = true;
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
                }
            }
            if (bl) continue;
            arrayList.add(zzfmv2);
        }
        return arrayList;
    }

    private static List<Object> zzc(@NonNull List<byte[]> list, @NonNull List<Object> list2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : list2) {
            try {
                Class.forName("com.google.android.gms.measurement.AppMeasurement$ConditionalUserProperty");
                String string = zzdyx.zzbe(object);
                String string2 = zzdyx.zzbf(object);
                boolean bl = true;
                Iterator<byte[]> iterator = list.iterator();
                while (iterator.hasNext()) {
                    zzfmv zzfmv2 = zzdyx.zzam(iterator.next());
                    if (zzfmv2 == null) {
                        if (!Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) continue;
                        Log.v((String)"FirebaseAbtUtil", (String)"Couldn't deserialize the payload; skipping.");
                        continue;
                    }
                    if (!zzfmv2.zzpzs.equals(string) || !zzfmv2.zzpzt.equals(string2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList.add(object);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
            }
        }
        return arrayList;
    }

    private static void zza(@NonNull Context context, @NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4) {
        if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
            String string5 = String.valueOf(string);
            Log.v((String)"FirebaseAbtUtil", (String)(string5.length() != 0 ? "_CE(experimentId) called by ".concat(string5) : new String("_CE(experimentId) called by ")));
        }
        if (!zzdyx.zzey(context)) {
            return;
        }
        AppMeasurement appMeasurement = zzdyx.zzde(context);
        try {
            Method method = AppMeasurement.class.getDeclaredMethod("clearConditionalUserProperty", String.class, String.class, Bundle.class);
            method.setAccessible(true);
            if (Log.isLoggable((String)"FirebaseAbtUtil", (int)2)) {
                Log.v((String)"FirebaseAbtUtil", (String)new StringBuilder(17 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Clearing _E: [").append(string2).append(", ").append(string3).append("]").toString());
            }
            method.invoke((Object)appMeasurement, string2, string4, zzdyx.zzay(string2, string3));
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
            return;
        }
    }

    public static long zza(long l, @Nullable List<byte[]> list) {
        if (list == null) {
            return l;
        }
        for (byte[] byArray : list) {
            zzfmv zzfmv2;
            if (byArray == null || (zzfmv2 = zzdyx.zzam(byArray)) == null || zzfmv2.zzpzu <= l) continue;
            l = zzfmv2.zzpzu;
        }
        return l;
    }

    private static String zza(@Nullable zzfmv zzfmv2, @NonNull zzdyw zzdyw2) {
        if (zzfmv2 != null && !TextUtils.isEmpty((CharSequence)zzfmv2.zzpzz)) {
            return zzfmv2.zzpzz;
        }
        return zzdyw2.zzbtc();
    }

    private static int zzb(@NonNull AppMeasurement appMeasurement, @NonNull String string) {
        try {
            Method method = AppMeasurement.class.getDeclaredMethod("getMaxUserProperties", String.class);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)appMeasurement, string);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Log.e((String)"FirebaseAbtUtil", (String)"Could not complete the operation due to an internal error.", (Throwable)reflectiveOperationException);
            return 20;
        }
    }

    @Nullable
    private static zzfmv zzam(@NonNull byte[] byArray) {
        try {
            return zzfmv.zzbi((byte[])byArray);
        }
        catch (zzflr zzflr2) {
            return null;
        }
    }
}

