/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzai;
import com.google.android.gms.common.util.zzw;

public final class FirebaseOptions {
    private final String ve;
    private final String gp;
    private final String aMG;
    private final String aMH;
    private final String vh;
    private final String vi;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzab.zza((!zzw.zzib((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.gp = string;
        this.ve = string2;
        this.aMG = string3;
        this.aMH = string4;
        this.vh = string5;
        this.vi = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzai zzai2 = new zzai(context);
        String string = zzai2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzai2.getString("google_api_key"), zzai2.getString("firebase_database_url"), zzai2.getString("ga_trackingId"), zzai2.getString("gcm_defaultSenderId"), zzai2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.ve;
    }

    public String getApplicationId() {
        return this.gp;
    }

    public String getDatabaseUrl() {
        return this.aMG;
    }

    public String getGcmSenderId() {
        return this.vh;
    }

    public String getStorageBucket() {
        return this.vi;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzaa.equal((Object)this.gp, (Object)firebaseOptions.gp) && zzaa.equal((Object)this.ve, (Object)firebaseOptions.ve) && zzaa.equal((Object)this.aMG, (Object)firebaseOptions.aMG) && zzaa.equal((Object)this.aMH, (Object)firebaseOptions.aMH) && zzaa.equal((Object)this.vh, (Object)firebaseOptions.vh) && zzaa.equal((Object)this.vi, (Object)firebaseOptions.vi);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.gp, this.ve, this.aMG, this.aMH, this.vh, this.vi});
    }

    public String toString() {
        return zzaa.zzx((Object)this).zzg("applicationId", (Object)this.gp).zzg("apiKey", (Object)this.ve).zzg("databaseUrl", (Object)this.aMG).zzg("gcmSenderId", (Object)this.vh).zzg("storageBucket", (Object)this.vi).toString();
    }

    public static final class Builder {
        private String ve;
        private String gp;
        private String aMG;
        private String aMH;
        private String vh;
        private String vi;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.gp = firebaseOptions.gp;
            this.ve = firebaseOptions.ve;
            this.aMG = firebaseOptions.aMG;
            this.aMH = firebaseOptions.aMH;
            this.vh = firebaseOptions.vh;
            this.vi = firebaseOptions.vi;
        }

        public Builder setApiKey(@NonNull String string) {
            this.ve = zzab.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.gp = zzab.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.aMG = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.vh = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.vi = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.gp, this.ve, this.aMG, this.aMH, this.vh, this.vi);
        }
    }
}

