/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.concurrent;

import com.google.firebase.concurrent.DelegatingScheduledExecutorService;
import com.google.firebase.concurrent.ExecutorsRegistrar;
import com.google.firebase.concurrent.LimitedConcurrencyExecutor;
import com.google.firebase.concurrent.LimitedConcurrencyExecutorService;
import com.google.firebase.concurrent.PausableExecutor;
import com.google.firebase.concurrent.PausableExecutorImpl;
import com.google.firebase.concurrent.PausableExecutorService;
import com.google.firebase.concurrent.PausableExecutorServiceImpl;
import com.google.firebase.concurrent.PausableScheduledExecutorService;
import com.google.firebase.concurrent.PausableScheduledExecutorServiceImpl;
import com.google.firebase.concurrent.SequentialExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class FirebaseExecutors {
    private FirebaseExecutors() {
    }

    public static Executor newSequentialExecutor(Executor delegate) {
        return new SequentialExecutor(delegate);
    }

    public static Executor newLimitedConcurrencyExecutor(Executor delegate, int concurrency) {
        return new LimitedConcurrencyExecutor(delegate, concurrency);
    }

    public static ExecutorService newLimitedConcurrencyExecutorService(ExecutorService delegate, int concurrency) {
        return new LimitedConcurrencyExecutorService(delegate, concurrency);
    }

    public static ScheduledExecutorService newLimitedConcurrencyScheduledExecutorService(ExecutorService delegate, int concurrency) {
        return new DelegatingScheduledExecutorService(FirebaseExecutors.newLimitedConcurrencyExecutorService(delegate, concurrency), (ScheduledExecutorService)ExecutorsRegistrar.SCHEDULER.get());
    }

    public static PausableExecutor newPausableExecutor(Executor delegate) {
        return new PausableExecutorImpl(false, delegate);
    }

    public static PausableExecutorService newPausableExecutorService(ExecutorService delegate) {
        return new PausableExecutorServiceImpl(false, delegate);
    }

    public static PausableScheduledExecutorService newPausableScheduledExecutorService(ScheduledExecutorService delegate) {
        return new PausableScheduledExecutorServiceImpl(FirebaseExecutors.newPausableExecutorService(delegate), (ScheduledExecutorService)ExecutorsRegistrar.SCHEDULER.get());
    }

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    private static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

