/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.components.AbstractComponentContainer;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.ComponentSorter;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.EventBus;
import com.google.firebase.components.Lazy;
import com.google.firebase.components.MissingDependencyException;
import com.google.firebase.components.RestrictedComponentContainer;
import com.google.firebase.events.Publisher;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ComponentRuntime
extends AbstractComponentContainer {
    private final List<Component<?>> components;
    private final Map<Class<?>, Lazy<?>> lazyInstanceMap = new HashMap();
    private final EventBus eventBus;

    public ComponentRuntime(Executor defaultEventExecutor, Iterable<ComponentRegistrar> registrars, Component<?> ... additionalComponents) {
        this.eventBus = new EventBus(defaultEventExecutor);
        ArrayList componentsToAdd = new ArrayList();
        componentsToAdd.add(Component.of(this.eventBus, EventBus.class, Subscriber.class, Publisher.class));
        for (ComponentRegistrar componentRegistrar : registrars) {
            componentsToAdd.addAll(componentRegistrar.getComponents());
        }
        Collections.addAll(componentsToAdd, additionalComponents);
        this.components = Collections.unmodifiableList(ComponentSorter.sorted(componentsToAdd));
        for (Component component : this.components) {
            this.register(component);
        }
        this.validateDependencies();
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> anInterface) {
        Preconditions.checkNotNull(anInterface, (Object)"Null interface requested.");
        return this.lazyInstanceMap.get(anInterface);
    }

    public void initializeEagerComponents(boolean isDefaultApp) {
        for (Component<?> component : this.components) {
            if (!component.isAlwaysEager() && (!component.isEagerInDefaultApp() || !isDefaultApp)) continue;
            this.get((Class)component.getProvidedInterfaces().iterator().next());
        }
        this.eventBus.enablePublishingAndFlushPending();
    }

    private <T> void register(Component<T> component) {
        Lazy<T> lazy = new Lazy<T>(component.getFactory(), new RestrictedComponentContainer(component, this));
        for (Class<T> anInterface : component.getProvidedInterfaces()) {
            this.lazyInstanceMap.put(anInterface, lazy);
        }
    }

    private void validateDependencies() {
        for (Component<?> component : this.components) {
            for (Dependency dependency : component.getDependencies()) {
                if (!dependency.isRequired() || this.lazyInstanceMap.containsKey(dependency.getInterface())) continue;
                throw new MissingDependencyException(String.format("Unsatisfied dependency for component %s: %s", component, dependency.getInterface()));
            }
        }
    }
}

